/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.otyacraftengine.client.util;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import red.felnull.otyacraftengine.client.data.ReceiveTextureLoder;
import red.felnull.otyacraftengine.client.data.URLImageTextureLoder;
import red.felnull.otyacraftengine.client.renderer.texture.DynamicGifTexture;
import red.felnull.otyacraftengine.client.util.IKSGClientUtil;
import red.felnull.otyacraftengine.libs.com.madgag.gif.fmsware.GifDecoder;
import red.felnull.otyacraftengine.libs.dev.felnull.fnjl.util.FNImageUtil;
import red.felnull.otyacraftengine.util.IKSGFileLoadUtil;
import red.felnull.otyacraftengine.util.IKSGPlayerUtil;

@OnlyIn(value=Dist.CLIENT)
public class IKSGTextureUtil {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final ResourceLocation LOADING_1 = new ResourceLocation("otyacraftengine", "textures/gui/loading_icon/loading_1.png");
    private static final ResourceLocation LOADING_2 = new ResourceLocation("otyacraftengine", "textures/gui/loading_icon/loading_2.png");
    private static final ResourceLocation LOADING_3 = new ResourceLocation("otyacraftengine", "textures/gui/loading_icon/loading_3.png");
    private static final ResourceLocation LOADING_4 = new ResourceLocation("otyacraftengine", "textures/gui/loading_icon/loading_4.png");
    public static final ResourceLocation TEXTUER_LOADING = new ResourceLocation("otyacraftengine", "textures/gui/textuer_loading.png");
    public static final ResourceLocation TEXTUER_NOTFINED = new ResourceLocation("otyacraftengine", "textures/gui/textuer_not_find.png");
    public static int loadingPaatune;
    private static final Map<byte[], ResourceLocation> PICTUER_BYTE_LOCATION;

    public static ResourceLocation getPlayerSkinTexture(String name) {
        return IKSGTextureUtil.getPlayerTexture(MinecraftProfileTexture.Type.SKIN, name);
    }

    public static ResourceLocation getPlayerCapeTexture(String name) {
        return IKSGTextureUtil.getPlayerTexture(MinecraftProfileTexture.Type.CAPE, name);
    }

    public static ResourceLocation getPlayerElytraTexture(String name) {
        return IKSGTextureUtil.getPlayerTexture(MinecraftProfileTexture.Type.ELYTRA, name);
    }

    public static ResourceLocation getPlayerTexture(MinecraftProfileTexture.Type type, String name) {
        if (IKSGTextureUtil.mc.field_71439_g != null && name.equals(IKSGPlayerUtil.getUserName((PlayerEntity)IKSGTextureUtil.mc.field_71439_g))) {
            return IKSGTextureUtil.mc.field_71439_g.func_110306_p();
        }
        GameProfile GP = IKSGPlayerUtil.getPlayerProfile(name);
        Map map = mc.func_152342_ad().func_152788_a(GP);
        ResourceLocation faselocation = map.containsKey(type) ? mc.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(type), type) : DefaultPlayerSkin.func_177334_a((UUID)PlayerEntity.func_146094_a((GameProfile)GP));
        return faselocation;
    }

    public static ResourceLocation getPlayerSkinTextureByUUID(String uuid) {
        return IKSGTextureUtil.getPictureImageURLTexture(IKSGPlayerUtil.getPlayerSkinTextureURL(uuid));
    }

    public static ResourceLocation getPictureImageTexture(byte[] data) {
        if (PICTUER_BYTE_LOCATION.containsKey(data)) {
            return PICTUER_BYTE_LOCATION.get(data);
        }
        ResourceLocation imagelocation = new ResourceLocation("otyacraftengine", "pictuer/" + UUID.randomUUID());
        try {
            DynamicTexture texture = IKSGTextureUtil.loadImageTexture(data);
            mc.func_222817_e(() -> IKSGTextureUtil.mc.field_71446_o.func_229263_a_(imagelocation, (Texture)texture)).get();
            PICTUER_BYTE_LOCATION.put(data, imagelocation);
            return imagelocation;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static DynamicTexture loadImageTexture(byte[] data) throws IOException {
        GifDecoder decoder = new GifDecoder();
        if (decoder.read(new ByteArrayInputStream(data)) == 0) {
            DynamicGifTexture.ImageFrame[] frames = new DynamicGifTexture.ImageFrame[decoder.getFrameCount()];
            long duration = 0L;
            for (int i = 0; i < decoder.getFrameCount(); ++i) {
                frames[i] = new DynamicGifTexture.ImageFrame(NativeImage.func_195713_a((InputStream)FNImageUtil.toInputStream(decoder.getFrame(i), "png")), decoder.getDelay(i));
                duration += (long)decoder.getDelay(i);
            }
            return new DynamicGifTexture(duration, frames);
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        NativeImage NI = NativeImage.func_195713_a((InputStream)bis);
        return new DynamicTexture(NI);
    }

    public static ResourceLocation getLoadingIconTextuer() {
        if (loadingPaatune == 0) {
            return LOADING_1;
        }
        if (loadingPaatune == 1) {
            return LOADING_2;
        }
        if (loadingPaatune == 2) {
            return LOADING_3;
        }
        if (loadingPaatune == 3) {
            return LOADING_4;
        }
        return LOADING_1;
    }

    public static ResourceLocation getReceiveTexture(ResourceLocation location, String name) {
        String WORLDNAME_AND_PATH = IKSGClientUtil.getCurrentWorldUUID() + ":" + location.toString() + ":" + name;
        if (ReceiveTextureLoder.instance().PICTUER_RECEIVE_LOCATION.containsKey(WORLDNAME_AND_PATH)) {
            ReceiveTextureLoder.instance().updateLastTextuerTime(location, name);
            return ReceiveTextureLoder.instance().PICTUER_RECEIVE_LOCATION.get(WORLDNAME_AND_PATH);
        }
        String filename = ReceiveTextureLoder.instance().getIndexContainLocation(WORLDNAME_AND_PATH);
        if (filename != null && ReceiveTextureLoder.CASH_PATH.resolve("cash").resolve(filename).toFile().exists()) {
            ResourceLocation inmap = IKSGTextureUtil.getPictureImageTexture(IKSGFileLoadUtil.fileBytesReader(ReceiveTextureLoder.CASH_PATH.resolve("cash").resolve(filename)));
            ReceiveTextureLoder.instance().PICTUER_RECEIVE_LOCATION.put(WORLDNAME_AND_PATH, inmap);
            return inmap;
        }
        ReceiveTextureLoder.instance().PICTUER_RECEIVE_LOCATION.put(WORLDNAME_AND_PATH, TEXTUER_LOADING);
        ReceiveTextureLoder.instance().requestTextuerSend(WORLDNAME_AND_PATH, location, name);
        return TEXTUER_LOADING;
    }

    public static ResourceLocation getPictureImageURLTexture(String url) {
        return IKSGTextureUtil.getPictureImageURLTexture(url, 0, 0);
    }

    public static ResourceLocation getPictureImageURLTexture(String url, int width, int height) {
        URLImageTextureLoder.URLImageData urlid = new URLImageTextureLoder.URLImageData(url, width, height);
        if (URLImageTextureLoder.instance().PICTUER_URL_LOCATION.containsKey(urlid)) {
            return URLImageTextureLoder.instance().PICTUER_URL_LOCATION.get(urlid);
        }
        String filename = URLImageTextureLoder.instance().getIndexContainLocation(urlid);
        if (filename != null && URLImageTextureLoder.CASH_PATH.resolve("cash").resolve(filename).toFile().exists()) {
            ResourceLocation inmap = IKSGTextureUtil.getPictureImageTexture(IKSGFileLoadUtil.fileBytesReader(URLImageTextureLoder.CASH_PATH.resolve("cash").resolve(filename)));
            URLImageTextureLoder.instance().PICTUER_URL_LOCATION.put(urlid, inmap);
            return inmap;
        }
        URLImageTextureLoder.instance().PICTUER_URL_LOCATION.put(urlid, TEXTUER_LOADING);
        URLImageTextureLoder.instance().downloadTextuer(urlid);
        return TEXTUER_LOADING;
    }

    public static int getWidth(ResourceLocation location, int defalt) {
        Texture tex = IKSGTextureUtil.mc.field_71446_o.func_229267_b_(location);
        if (tex instanceof DynamicTexture) {
            return Objects.requireNonNull(((DynamicTexture)tex).func_195414_e()).func_195702_a();
        }
        return defalt;
    }

    public static int getHeight(ResourceLocation location, int defalt) {
        Texture tex = IKSGTextureUtil.mc.field_71446_o.func_229267_b_(location);
        if (tex instanceof DynamicTexture) {
            return Objects.requireNonNull(((DynamicTexture)tex).func_195414_e()).func_195714_b();
        }
        return defalt;
    }

    static {
        PICTUER_BYTE_LOCATION = Maps.newHashMap();
    }
}

