/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.otyacraftengine.data;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import red.felnull.otyacraftengine.util.IKSGFileLoadUtil;
import red.felnull.otyacraftengine.util.IKSGPathUtil;
import red.felnull.otyacraftengine.util.IKSGStringUtil;

public class SendReceiveLogger {
    private final String time = IKSGStringUtil.getTimeStamp();
    private final String name;
    private final StringBuffer log;
    private final Dist side;
    private final SndOrRec sr;

    public SendReceiveLogger(String name, String details, Dist side, SndOrRec sr) {
        this.name = name;
        this.side = side;
        this.log = new StringBuffer();
        this.log.append(details).append(" - ").append(sr.getName().getString()).append(" Log \n");
        this.sr = sr;
    }

    public void addExceptionLogLine(Exception ex) {
        this.addLogLine((ITextComponent)new TranslationTextComponent("rslog.exception", new Object[]{ex.toString()}));
    }

    public void addProgress(int sent, int remaing, long progress, long last, SndOrRec sr) {
        if (sr == SndOrRec.SEND) {
            this.addLogLine((ITextComponent)new TranslationTextComponent("rslog.sendProgress", new Object[]{sent + "byte", remaing + "byte", progress + "ms", last + "ms"}));
        } else if (sr == SndOrRec.RECEIVE) {
            this.addLogLine((ITextComponent)new TranslationTextComponent("rslog.receiveProgress", new Object[]{sent + "byte", remaing + "byte", progress + "ms", last + "ms"}));
        }
    }

    public void addStartFailureLogLine(ITextComponent st) {
        this.addLogLine((ITextComponent)new TranslationTextComponent("rslog.start.failure", new Object[]{this.sr.getName(), st}));
    }

    public void addFinishLogLine(SRResult result, long time, int allbyte) {
        String ep = time + "ms";
        if (result == SRResult.SUCCESS) {
            String speed = (long)allbyte / time + "byte/ms";
            this.addLogLine((ITextComponent)new TranslationTextComponent("rslog.finish.success", new Object[]{this.sr.getName(), ep, speed}));
        } else if (result == SRResult.FAILURE) {
            this.addLogLine((ITextComponent)new TranslationTextComponent("rslog.finish.failure", new Object[]{this.sr.getName(), ep}));
        }
    }

    public void addStartLogLine() {
        this.addLogLine((ITextComponent)new TranslationTextComponent("rslog.start.success", new Object[]{this.sr.getName()}));
    }

    public void addLogLine(ITextComponent log) {
        this.log.append(IKSGStringUtil.getTimeStamp()).append("-").append(log.getString()).append("\n");
    }

    public void createLog() {
        Path savedpath = null;
        if (this.side.isClient()) {
            savedpath = Paths.get("srlogs", new String[0]);
        } else if (this.side.isDedicatedServer()) {
            savedpath = IKSGPathUtil.getWorldSaveDataPath().resolve(Paths.get("srlogs", new String[0]));
        }
        IKSGFileLoadUtil.txtWriter(this.log.toString(), Objects.requireNonNull(savedpath).resolve(this.time.replace(":", "-").replace(" ", "-") + "-" + this.name.replace(":", "-") + "-" + this.sr.getInitials() + ".log"));
    }

    public static enum SRResult {
        SUCCESS((ITextComponent)new TranslationTextComponent("rslog.success")),
        FAILURE((ITextComponent)new TranslationTextComponent("rslog.failure"));

        private final ITextComponent name;

        private SRResult(ITextComponent name) {
            this.name = name;
        }

        public ITextComponent getName() {
            return this.name;
        }
    }

    public static enum SndOrRec {
        SEND((ITextComponent)new TranslationTextComponent("rslog.sending"), "s"),
        RECEIVE((ITextComponent)new TranslationTextComponent("rslog.receiving"), "r");

        private final ITextComponent name;
        private final String initials;

        private SndOrRec(ITextComponent name, String initials) {
            this.name = name;
            this.initials = initials;
        }

        public ITextComponent getName() {
            return this.name;
        }

        public String getInitials() {
            return this.initials;
        }
    }
}

