/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.otyacraftengine.data;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import red.felnull.otyacraftengine.api.event.common.ReceiverEvent;
import red.felnull.otyacraftengine.api.registries.OERegistries;
import red.felnull.otyacraftengine.data.DataReceiverBuffer;
import red.felnull.otyacraftengine.data.SendReceiveLogger;
import red.felnull.otyacraftengine.util.IKSGFileLoadUtil;
import red.felnull.otyacraftengine.util.IKSGPathUtil;
import red.felnull.otyacraftengine.util.IKSGServerUtil;

public class ServerDataReceiver
extends Thread {
    private static final Map<String, Map<String, DataReceiverBuffer>> RECEIVS = new HashMap<String, Map<String, DataReceiverBuffer>>();
    private final String name;
    private final String uuid;
    private final ResourceLocation location;
    private final String playerUUID;
    private final SendReceiveLogger logger;
    private int cont;
    private final long fristTime;
    private long logTime;

    public ServerDataReceiver(String playerUUID, String uuid, ResourceLocation location, String name, int datasize) {
        this.playerUUID = playerUUID;
        this.uuid = uuid;
        this.location = location;
        this.name = name;
        this.fristTime = System.currentTimeMillis();
        this.logTime = System.currentTimeMillis();
        if (!RECEIVS.containsKey(playerUUID)) {
            RECEIVS.put(playerUUID, new HashMap());
        }
        RECEIVS.get(playerUUID).put(uuid, new DataReceiverBuffer(datasize, uuid, location, name));
        String det = "PlayerUUID:" + playerUUID + " UUID:" + uuid + " Location:" + location.toString() + " Name:" + name + " Size:" + datasize + "byte";
        this.logger = new SendReceiveLogger(location.toString(), det, Dist.DEDICATED_SERVER, SendReceiveLogger.SndOrRec.RECEIVE);
    }

    public static void addBufferBytes(String pluuid, String uuid, byte[] bytes) {
        if (RECEIVS.containsKey(pluuid) && RECEIVS.get(pluuid).containsKey(uuid)) {
            RECEIVS.get(pluuid).get(uuid).addBytes(bytes);
        }
    }

    public void receiveFinish(SendReceiveLogger.SRResult result) {
        this.logger.addFinishLogLine(result, System.currentTimeMillis() - this.fristTime, RECEIVS.get(this.playerUUID).get(this.uuid).getCont());
        RECEIVS.get(this.playerUUID).remove(this.uuid);
        this.logger.createLog();
        MinecraftForge.EVENT_BUS.post((Event)new ReceiverEvent.Server.Pos(IKSGServerUtil.getMinecraftServer().func_184103_al().func_177451_a(UUID.fromString(this.playerUUID)), this.uuid, this.location, this.name, result));
    }

    @Override
    public void run() {
        try {
            this.logger.addStartLogLine();
            MinecraftForge.EVENT_BUS.post((Event)new ReceiverEvent.Server.Pre(IKSGServerUtil.getMinecraftServer().func_184103_al().func_177451_a(UUID.fromString(this.playerUUID)), this.uuid, this.location, this.name));
            long time = System.currentTimeMillis();
            while (!RECEIVS.get(this.playerUUID).get(this.uuid).isPerfectByte()) {
                if (System.currentTimeMillis() - this.logTime >= 3000L) {
                    this.logger.addProgress(RECEIVS.get(this.playerUUID).get(this.uuid).getCont(), ServerDataReceiver.RECEIVS.get((Object)this.playerUUID).get((Object)this.uuid).allcont - RECEIVS.get(this.playerUUID).get(this.uuid).getCont(), System.currentTimeMillis() - this.fristTime, System.currentTimeMillis() - time, SendReceiveLogger.SndOrRec.RECEIVE);
                    this.logTime = System.currentTimeMillis();
                }
                if (ServerDataReceiver.RECEIVS.get((Object)this.playerUUID).get((Object)this.uuid).stop) {
                    this.logger.addLogLine((ITextComponent)new TranslationTextComponent("rslog.err.stop"));
                    this.receiveFinish(SendReceiveLogger.SRResult.FAILURE);
                    return;
                }
                if (!IKSGServerUtil.isOnlinePlayer(this.playerUUID)) {
                    this.logger.addLogLine((ITextComponent)new TranslationTextComponent("rslog.err.playerExitedWorld"));
                    this.receiveFinish(SendReceiveLogger.SRResult.FAILURE);
                    return;
                }
                if (this.cont == RECEIVS.get(this.playerUUID).get(this.uuid).getCont() && System.currentTimeMillis() - time >= 10000L) {
                    this.logger.addLogLine((ITextComponent)new TranslationTextComponent("rslog.err.timeout"));
                    this.receiveFinish(SendReceiveLogger.SRResult.FAILURE);
                    return;
                }
                if (this.cont != RECEIVS.get(this.playerUUID).get(this.uuid).getCont()) {
                    this.cont = RECEIVS.get(this.playerUUID).get(this.uuid).getCont();
                    time = System.currentTimeMillis();
                    MinecraftForge.EVENT_BUS.post((Event)new ReceiverEvent.Server.Run(IKSGServerUtil.getMinecraftServer().func_184103_al().func_177451_a(UUID.fromString(this.playerUUID)), this.uuid, this.location, this.name, ServerDataReceiver.RECEIVS.get((Object)this.playerUUID).get((Object)this.uuid).allcont, this.cont));
                }
                ServerDataReceiver.sleep(1L);
            }
            IKSGFileLoadUtil.fileBytesWriter(RECEIVS.get(this.playerUUID).get(this.uuid).getBytes(), IKSGPathUtil.getWorldSaveDataPath().resolve(OERegistries.SERVER_RECEVED_PATH.get(this.location).resolve(this.name)));
        }
        catch (Exception ex) {
            this.logger.addExceptionLogLine(ex);
            ex.printStackTrace();
            this.receiveFinish(SendReceiveLogger.SRResult.FAILURE);
        }
        this.receiveFinish(SendReceiveLogger.SRResult.SUCCESS);
    }
}

