/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.otyacraftengine.data;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.zip.GZIPOutputStream;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import red.felnull.otyacraftengine.OtyacraftEngine;
import red.felnull.otyacraftengine.api.event.common.SenderEvent;
import red.felnull.otyacraftengine.data.SendReceiveLogger;
import red.felnull.otyacraftengine.packet.PacketHandler;
import red.felnull.otyacraftengine.packet.ServerDataSendMessage;
import red.felnull.otyacraftengine.util.IKSGFileLoadUtil;
import red.felnull.otyacraftengine.util.IKSGPathUtil;
import red.felnull.otyacraftengine.util.IKSGPlayerUtil;
import red.felnull.otyacraftengine.util.IKSGServerUtil;
import red.felnull.otyacraftengine.util.IKSGStringUtil;

public class ServerDataSender
extends Thread {
    public static int max = 5;
    private static final Map<String, Map<String, ServerDataSender>> SENDS = new HashMap<String, Map<String, ServerDataSender>>();
    private final String playerUUID;
    private final String name;
    private final String uuid;
    private final ResourceLocation location;
    private final long fristTime;
    private final SendReceiveLogger logger;
    public int dataCont;
    public boolean response = false;
    private byte[] sendingData;
    private long time;
    private long logTime;
    private boolean stop;
    private long lastResponseTime;

    public ServerDataSender(String playerUUID, String uuid, ResourceLocation location, String name, byte[] data) {
        this.playerUUID = playerUUID;
        this.uuid = uuid;
        this.location = location;
        this.name = name;
        this.sendingData = data;
        this.logTime = System.currentTimeMillis();
        this.lastResponseTime = System.currentTimeMillis();
        this.fristTime = System.currentTimeMillis();
        String det = "PlayerUUID:" + playerUUID + " UUID:" + uuid + " Location:" + location.toString() + " Name:" + name + " Size:" + (data == null ? "0" : Integer.valueOf(data.length)) + "byte";
        this.logger = new SendReceiveLogger(location.toString(), det, Dist.DEDICATED_SERVER, SendReceiveLogger.SndOrRec.SEND);
    }

    public static boolean isMaxSending(String playerUUID) {
        if (!SENDS.containsKey(playerUUID)) {
            return false;
        }
        return SENDS.get(playerUUID).size() >= max;
    }

    public static void response(String playerUUID, String uuid) {
        if (SENDS.containsKey(playerUUID) && SENDS.get(playerUUID).containsKey(uuid)) {
            ServerDataSender.SENDS.get((Object)playerUUID).get((Object)uuid).response = true;
        }
    }

    public static void sending(String playerUUID, String uuid, ResourceLocation location, String name, byte[] data) {
        ServerDataSender sds = new ServerDataSender(playerUUID, uuid, location, name, data);
        sds.sendStart();
    }

    public static void srlogsGziping() {
        if (!IKSGPathUtil.getWorldSaveDataPath().resolve(Paths.get("srlogs", new String[0])).toFile().exists()) {
            return;
        }
        File[] files = IKSGPathUtil.getWorldSaveDataPath().resolve(Paths.get("srlogs", new String[0])).toFile().listFiles(file -> IKSGStringUtil.getExtension(file.getName()).equals("log"));
        if (files.length == 0) {
            return;
        }
        File mostold = null;
        File mostnew = null;
        for (File file2 : files) {
            if (mostold == null || mostnew == null) {
                mostold = file2;
                mostnew = file2;
                continue;
            }
            if (mostold.lastModified() < file2.lastModified()) {
                mostold = file2;
            }
            if (mostnew.lastModified() <= file2.lastModified()) continue;
            mostnew = file2;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            for (File file3 : files) {
                byte[] bytes = IKSGFileLoadUtil.fileBytesReader(file3.toPath());
                GZIPOutputStream gzip_out = new GZIPOutputStream(out);
                gzip_out.write(Objects.requireNonNull(bytes));
                gzip_out.close();
            }
            out.close();
            byte[] ret = out.toByteArray();
            String name = "";
            name = mostold == mostnew ? mostnew.getName() : IKSGStringUtil.deleteExtension(mostold.getName()) + "~" + IKSGStringUtil.deleteExtension(mostnew.getName());
            IKSGFileLoadUtil.fileBytesWriter(ret, IKSGPathUtil.getWorldSaveDataPath().resolve(Paths.get("srlogs\\" + name + ".log.gz", new String[0])));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        for (File file4 : files) {
            IKSGFileLoadUtil.deleteFile(file4);
        }
    }

    public void sendStart() {
        if (!SENDS.containsKey(this.playerUUID)) {
            SENDS.put(this.playerUUID, new HashMap());
        }
        if (ServerDataSender.isMaxSending(this.playerUUID)) {
            OtyacraftEngine.LOGGER.error("The data cont that can be sent at one time is exceeded : " + this.location.toString() + " : " + this.name);
            this.sendingData = null;
            this.logger.addStartFailureLogLine((ITextComponent)new TranslationTextComponent("rslog.err.excessSimultaneousSending"));
            this.logger.addFinishLogLine(SendReceiveLogger.SRResult.FAILURE, System.currentTimeMillis() - this.fristTime, this.sendingData == null ? 0 : this.sendingData.length);
            this.logger.createLog();
            return;
        }
        SENDS.get(this.playerUUID).put(this.uuid, this);
        this.start();
    }

    public void sentFinish(SendReceiveLogger.SRResult result) {
        this.logger.addFinishLogLine(result, System.currentTimeMillis() - this.fristTime, this.sendingData.length);
        this.sendingData = null;
        SENDS.get(this.playerUUID).remove(this.uuid);
        this.logger.createLog();
        MinecraftForge.EVENT_BUS.post((Event)new SenderEvent.Server.Pos(IKSGServerUtil.getMinecraftServer().func_184103_al().func_177451_a(UUID.fromString(this.playerUUID)), this.uuid, this.location, this.name, result));
    }

    @Override
    public void run() {
        try {
            if (this.sendingData == null) {
                OtyacraftEngine.LOGGER.info("Null Sender Data : " + this.location.toString() + " : " + this.name);
                this.logger.addStartFailureLogLine((ITextComponent)new TranslationTextComponent("rslog.err.nulldata"));
                this.sentFinish(SendReceiveLogger.SRResult.FAILURE);
            }
            this.logger.addStartLogLine();
            MinecraftForge.EVENT_BUS.post((Event)new SenderEvent.Server.Pre(IKSGServerUtil.getMinecraftServer().func_184103_al().func_177451_a(UUID.fromString(this.playerUUID)), this.uuid, this.location, this.name));
            boolean frist = true;
            int sendbyte = 8192;
            int soundbytelengt = this.sendingData.length;
            for (int i = 0; i < soundbytelengt; i += sendbyte) {
                byte[] sndingbyte = new byte[Math.min(soundbytelengt - i, sendbyte)];
                System.arraycopy(this.sendingData, i, sndingbyte, 0, sndingbyte.length);
                this.dataCont += sndingbyte.length;
                ServerDataSendMessage sendpacet = frist ? new ServerDataSendMessage(this.uuid, this.location, this.name, sndingbyte, this.sendingData.length, true) : new ServerDataSendMessage(this.uuid, sndingbyte);
                PacketHandler.sendPacket(IKSGPlayerUtil.getPlayerByUUID(this.playerUUID), sendpacet);
                MinecraftForge.EVENT_BUS.post((Event)new SenderEvent.Server.Run(IKSGServerUtil.getMinecraftServer().func_184103_al().func_177451_a(UUID.fromString(this.playerUUID)), this.uuid, this.location, this.name, this.sendingData.length, this.dataCont));
                sndingbyte = null;
                frist = false;
                this.time = System.currentTimeMillis();
                while (!this.response) {
                    if (System.currentTimeMillis() - this.logTime >= 3000L) {
                        this.logger.addProgress(this.dataCont, this.sendingData.length - this.dataCont, System.currentTimeMillis() - this.fristTime, System.currentTimeMillis() - this.lastResponseTime, SendReceiveLogger.SndOrRec.SEND);
                        this.logTime = System.currentTimeMillis();
                    }
                    if (!IKSGServerUtil.isOnlinePlayer(this.playerUUID)) {
                        this.logger.addLogLine((ITextComponent)new TranslationTextComponent("rslog.err.playerExitedWorld"));
                        this.sentFinish(SendReceiveLogger.SRResult.FAILURE);
                        return;
                    }
                    if (this.stop) {
                        this.logger.addLogLine((ITextComponent)new TranslationTextComponent("rslog.err.stop"));
                        this.sentFinish(SendReceiveLogger.SRResult.FAILURE);
                        return;
                    }
                    if (System.currentTimeMillis() - this.time >= 10000L) {
                        this.logger.addLogLine((ITextComponent)new TranslationTextComponent("rslog.err.timeout"));
                        this.sentFinish(SendReceiveLogger.SRResult.FAILURE);
                        return;
                    }
                    ServerDataSender.sleep(1L);
                }
                this.response = false;
                this.lastResponseTime = System.currentTimeMillis();
            }
        }
        catch (Exception ex) {
            this.logger.addExceptionLogLine(ex);
            ex.printStackTrace();
            this.sentFinish(SendReceiveLogger.SRResult.FAILURE);
        }
        this.sentFinish(SendReceiveLogger.SRResult.SUCCESS);
    }
}

