/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.otyacraftengine.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import red.felnull.otyacraftengine.api.registries.OERegistries;
import red.felnull.otyacraftengine.data.PlayerWorldData;
import red.felnull.otyacraftengine.data.WorldData;
import red.felnull.otyacraftengine.util.IKSGFileLoadUtil;
import red.felnull.otyacraftengine.util.IKSGPathUtil;
import red.felnull.otyacraftengine.util.IKSGPlayerUtil;

public class WorldDataManager {
    public static final Logger LOGGER = LogManager.getLogger(WorldDataManager.class);
    private static WorldDataManager INSTANCE;
    public final Map<ResourceLocation, CompoundNBT> WORLD_DATA = new HashMap<ResourceLocation, CompoundNBT>();
    public final Map<String, Map<ResourceLocation, CompoundNBT>> PLAYER_DATA = new HashMap<String, Map<ResourceLocation, CompoundNBT>>();
    public final Map<ResourceLocation, CompoundNBT> CLIENT_PLAYER_DATA = new HashMap<ResourceLocation, CompoundNBT>();

    public static WorldDataManager instance() {
        return INSTANCE;
    }

    public static void init() {
        INSTANCE = new WorldDataManager();
    }

    public void load(MinecraftServer ms, ServerPlayerEntity player) {
        if (player == null) {
            LOGGER.debug("loading data");
            for (Map.Entry<ResourceLocation, WorldData> rege : OERegistries.WORLD_DATA.entrySet()) {
                CompoundNBT tag = null;
                tag = IKSGPathUtil.getWorldSaveDataPath().resolve(rege.getValue().getSavedFolderPath()).toFile().exists() ? IKSGFileLoadUtil.fileNBTReader(IKSGPathUtil.getWorldSaveDataPath().resolve(rege.getValue().getSavedFolderPath())) : new CompoundNBT();
                this.WORLD_DATA.put(rege.getKey(), this.initialNBT(tag, rege.getValue().getInitialNBT(new CompoundNBT())));
            }
        } else {
            LOGGER.debug("loading " + player.func_200200_C_().getString() + " data");
            if (!this.PLAYER_DATA.containsKey(IKSGPlayerUtil.getUUID((PlayerEntity)player))) {
                this.PLAYER_DATA.put(IKSGPlayerUtil.getUUID((PlayerEntity)player), new HashMap());
            }
            for (Map.Entry<ResourceLocation, PlayerWorldData> rege : OERegistries.PLAYER_WORLD_DATA.entrySet()) {
                CompoundNBT tag = null;
                tag = IKSGPathUtil.getWorldSaveDataPath().resolve(rege.getValue().getSavedFolderPath()).resolve(IKSGPlayerUtil.getUUID((PlayerEntity)player) + ".dat").toFile().exists() ? IKSGFileLoadUtil.fileNBTReader(IKSGPathUtil.getWorldSaveDataPath().resolve(rege.getValue().getSavedFolderPath()).resolve(IKSGPlayerUtil.getUUID((PlayerEntity)player) + ".dat")) : new CompoundNBT();
                this.PLAYER_DATA.get(IKSGPlayerUtil.getUUID((PlayerEntity)player)).put(rege.getKey(), this.initialNBT(tag, rege.getValue().getInitialNBT(new CompoundNBT())));
            }
        }
    }

    private CompoundNBT initialNBT(CompoundNBT tag, CompoundNBT intedtag) {
        for (String intags : intedtag.func_150296_c()) {
            if (!tag.func_74764_b(intags)) {
                tag.func_218657_a(intags, Objects.requireNonNull(intedtag.func_74781_a(intags)));
                continue;
            }
            if (!tag.func_150297_b(intags, 10) || !intedtag.func_150297_b(intags, 10)) continue;
            tag.func_218657_a(intags, (INBT)this.initialNBT(tag.func_74775_l(intags), intedtag.func_74775_l(intags)));
        }
        return tag;
    }

    public void save(MinecraftServer ms, ServerPlayerEntity player) {
        if (player == null) {
            LOGGER.debug("saveing data");
            for (Map.Entry<ResourceLocation, CompoundNBT> ent : this.WORLD_DATA.entrySet()) {
                WorldData data = OERegistries.WORLD_DATA.get(ent.getKey());
                IKSGFileLoadUtil.fileNBTWriter(ent.getValue(), IKSGPathUtil.getWorldSaveDataPath().resolve(data.getSavedFolderPath()));
            }
            for (String pl : ms.func_184103_al().func_72369_d()) {
                ServerPlayerEntity spe = ms.func_184103_al().func_152612_a(pl);
                for (Map.Entry<ResourceLocation, CompoundNBT> ent : this.PLAYER_DATA.get(IKSGPlayerUtil.getUUID((PlayerEntity)spe)).entrySet()) {
                    PlayerWorldData data = OERegistries.PLAYER_WORLD_DATA.get(ent.getKey());
                    IKSGFileLoadUtil.fileNBTWriter(ent.getValue(), IKSGPathUtil.getWorldSaveDataPath().resolve(data.getSavedFolderPath()).resolve(IKSGPlayerUtil.getUUID((PlayerEntity)spe) + ".dat"));
                }
            }
        } else {
            LOGGER.debug("saveing " + player.func_200200_C_().getString() + " data");
            for (Map.Entry<ResourceLocation, CompoundNBT> ent : this.PLAYER_DATA.get(IKSGPlayerUtil.getUUID((PlayerEntity)player)).entrySet()) {
                PlayerWorldData data = OERegistries.PLAYER_WORLD_DATA.get(ent.getKey());
                IKSGFileLoadUtil.fileNBTWriter(ent.getValue(), IKSGPathUtil.getWorldSaveDataPath().resolve(data.getSavedFolderPath()).resolve(IKSGPlayerUtil.getUUID((PlayerEntity)player) + ".dat"));
            }
        }
    }

    public void unload(MinecraftServer ms, ServerPlayerEntity player) {
        if (player == null) {
            LOGGER.debug("unloding data");
            this.WORLD_DATA.clear();
            this.PLAYER_DATA.clear();
        } else {
            LOGGER.debug("unloding " + IKSGPlayerUtil.getUserName((PlayerEntity)player) + " data");
            if (this.PLAYER_DATA.containsKey(IKSGPlayerUtil.getUUID((PlayerEntity)player))) {
                this.PLAYER_DATA.get(IKSGPlayerUtil.getUUID((PlayerEntity)player)).clear();
            }
        }
    }

    public void unloadClient() {
        this.CLIENT_PLAYER_DATA.clear();
    }

    public CompoundNBT getPlayerWorldData(PlayerEntity player, ResourceLocation location, boolean isClientSide) {
        return this.getPlayerData(IKSGPlayerUtil.getUUID(player), location, isClientSide);
    }

    public CompoundNBT getWorldData(ResourceLocation location) {
        return this.WORLD_DATA.get(location);
    }

    public CompoundNBT getPlayerData(String uuid, ResourceLocation location, boolean isClientSide) {
        if (isClientSide) {
            return this.CLIENT_PLAYER_DATA.get(location);
        }
        if (!this.PLAYER_DATA.containsKey(uuid)) {
            return null;
        }
        return this.PLAYER_DATA.get(uuid).get(location);
    }
}

