/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.otyacraftengine.handler;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import red.felnull.otyacraftengine.api.ResponseSender;
import red.felnull.otyacraftengine.api.event.common.ResponseEvent;
import red.felnull.otyacraftengine.api.event.server.StraddleChunkEvent;
import red.felnull.otyacraftengine.api.event.server.WorldDataEvent;
import red.felnull.otyacraftengine.api.registries.OERegistries;
import red.felnull.otyacraftengine.data.ReceiveTextureManager;
import red.felnull.otyacraftengine.data.ServerDataSendReservation;
import red.felnull.otyacraftengine.data.ServerDataSender;
import red.felnull.otyacraftengine.data.WorldDataManager;
import red.felnull.otyacraftengine.util.IKSGModUtil;
import red.felnull.otyacraftengine.util.IKSGNBTUtil;
import red.felnull.otyacraftengine.util.IKSGPlayerUtil;
import red.felnull.otyacraftengine.util.IKSGServerUtil;

public class ServerHandler {
    private static final ResourceLocation SERVER_RESPONSE = new ResourceLocation("otyacraftengine", "server_response");
    public static Map<PlayerEntity, ChunkPos> PLAYER_CPOS = new HashMap<PlayerEntity, ChunkPos>();
    public static Map<PlayerEntity, ResourceLocation> PLAYER_DIMS = new HashMap<PlayerEntity, ResourceLocation>();
    public static final ResourceLocation CLIENT_WORLDUUID_SYNC = new ResourceLocation("otyacraftengine", "clientworlduuidsync");

    @SubscribeEvent
    public static void onServetTick(TickEvent.ServerTickEvent e) {
        ServerDataSendReservation.tick();
    }

    @SubscribeEvent
    public static void onServerStarting(FMLServerStartingEvent e) {
        WorldDataEvent.load(e.getServer(), null, false);
        ServerDataSender.srlogsGziping();
        CompoundNBT omvtag = WorldDataManager.instance().getWorldData(OERegistries.WORDDEFINITIVEDATA).func_74775_l("OldModVersion");
        IKSGNBTUtil.clearTag(omvtag);
        CompoundNBT mvtag = WorldDataManager.instance().getWorldData(OERegistries.WORDDEFINITIVEDATA).func_74775_l("ModVersion");
        mvtag.func_150296_c().forEach(n -> omvtag.func_218657_a(n, mvtag.func_74781_a(n)));
        IKSGNBTUtil.clearTag(mvtag);
        ModList.get().getMods().forEach(n -> mvtag.func_74778_a(n.getModId(), IKSGModUtil.getModVersion(n.getModId())));
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        if (!e.getPlayer().field_70170_p.field_72995_K) {
            WorldDataEvent.load(e.getPlayer().func_184102_h(), (ServerPlayerEntity)e.getPlayer(), false);
            ResponseSender.sendToClient((ServerPlayerEntity)e.getPlayer(), CLIENT_WORLDUUID_SYNC, 0, IKSGServerUtil.getWorldUUID().toString(), new CompoundNBT());
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent e) {
        if (!e.getPlayer().field_70170_p.field_72995_K) {
            WorldDataEvent.save(e.getPlayer().func_184102_h(), (ServerPlayerEntity)e.getPlayer(), true);
            WorldDataEvent.unload(e.getPlayer().func_184102_h(), (ServerPlayerEntity)e.getPlayer(), false);
            ResponseSender.sendToClient((ServerPlayerEntity)e.getPlayer(), CLIENT_WORLDUUID_SYNC, 1, "", new CompoundNBT());
        }
    }

    @SubscribeEvent
    public static void onServerStopping(FMLServerStoppingEvent e) {
        WorldDataEvent.save(e.getServer(), null, false);
        WorldDataEvent.unload(e.getServer(), null, false);
    }

    @SubscribeEvent
    public static void onWorldSave(WorldEvent.Save e) {
        WorldDataEvent.save(IKSGServerUtil.getMinecraftServer(), null, false);
    }

    @SubscribeEvent
    public static void onClientResponse(ResponseEvent.Client e) {
        if (e.getLocation().equals((Object)SERVER_RESPONSE)) {
            if (e.getId() == 0) {
                ServerDataSender.response(IKSGPlayerUtil.getUUID((PlayerEntity)e.getPlayer()), e.getMessage());
            }
        } else if (e.getLocation().equals((Object)new ResourceLocation("otyacraftengine", "textuerrequest")) && e.getId() == 0) {
            ReceiveTextureManager.instance().requestedTextuerSendServer(e.getData().func_74779_i("index"), e.getPlayer(), new ResourceLocation(e.getData().func_74779_i("location")), e.getMessage());
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent e) {
        if (!e.player.field_70170_p.field_72995_K) {
            if (!PLAYER_DIMS.containsKey(e.player)) {
                PLAYER_DIMS.put(e.player, e.player.field_70170_p.func_234923_W_().func_240901_a_());
            } else if (!PLAYER_DIMS.get(e.player).equals((Object)e.player.field_70170_p.func_234923_W_().func_240901_a_())) {
                PLAYER_DIMS.put(e.player, e.player.field_70170_p.func_234923_W_().func_240901_a_());
                PLAYER_CPOS.remove(e.player);
            }
            if (!PLAYER_CPOS.containsKey(e.player)) {
                MinecraftForge.EVENT_BUS.post((Event)new StraddleChunkEvent(e.player, new ChunkPos(e.player.func_233580_cy_()), new ChunkPos(e.player.func_233580_cy_())));
                PLAYER_CPOS.put(e.player, new ChunkPos(e.player.func_233580_cy_()));
            } else if (!PLAYER_CPOS.get(e.player).equals((Object)new ChunkPos(e.player.func_233580_cy_()))) {
                MinecraftForge.EVENT_BUS.post((Event)new StraddleChunkEvent(e.player, PLAYER_CPOS.get(e.player), new ChunkPos(e.player.func_233580_cy_())));
                PLAYER_CPOS.put(e.player, new ChunkPos(e.player.func_233580_cy_()));
            }
        }
    }
}

