/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.otyacraftengine.handler;

import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import red.felnull.otyacraftengine.api.event.server.WorldDataEvent;
import red.felnull.otyacraftengine.data.WorldDataManager;

public class WorldDataHandler {
    @SubscribeEvent
    public static void onLoad(WorldDataEvent.Load e) {
        if (e.isThread()) {
            DataThread dt = new DataThread(0, e.getServer(), e.getPlayer());
            dt.start();
        } else {
            WorldDataManager.instance().load(e.getServer(), e.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onSave(WorldDataEvent.Save e) {
        if (e.isThread()) {
            DataThread dt = new DataThread(1, e.getServer(), e.getPlayer());
            dt.start();
        } else {
            WorldDataManager.instance().save(e.getServer(), e.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onUnLoad(WorldDataEvent.UnLoad e) {
        if (e.isThread()) {
            DataThread dt = new DataThread(2, e.getServer(), e.getPlayer());
            dt.start();
        } else {
            WorldDataManager.instance().unload(e.getServer(), e.getPlayer());
        }
    }

    private static class DataThread
    extends Thread {
        private int num;
        private MinecraftServer ms;
        private ServerPlayerEntity player;

        public DataThread(int num, MinecraftServer ms, ServerPlayerEntity playerEntity) {
            this.num = num;
            this.ms = ms;
            this.player = playerEntity;
        }

        @Override
        public void run() {
            if (this.num == 0) {
                WorldDataManager.instance().load(this.ms, this.player);
            } else if (this.num == 1) {
                WorldDataManager.instance().save(this.ms, this.player);
            } else if (this.num == 2) {
                WorldDataManager.instance().unload(this.ms, this.player);
            }
        }
    }
}

