/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.otyacraftengine.util;

import java.util.HashMap;
import java.util.Map;

public class ClockTimer {
    private Map<String, Long> timers = new HashMap<String, Long>();
    private Map<String, ITask> tasks = new HashMap<String, ITask>();
    private Map<String, Long> taskTimes = new HashMap<String, Long>();
    private IAllExist allExist;

    public ClockTimer(IAllExist isExist) {
        this.allExist = isExist;
        TaskThread tt = new TaskThread(this);
        tt.start();
    }

    public void setTimer(String name) {
        this.timers.put(name, System.currentTimeMillis());
    }

    public long getTime(String name) {
        if (this.timers.containsKey(name)) {
            return this.timers.get(name);
        }
        return 0L;
    }

    public long getElapsedTime(String name) {
        return System.currentTimeMillis() - this.getTime(name);
    }

    public void addTask(String name, ITask task) {
        this.tasks.put(name, task);
        this.taskTimes.put(name, 0L);
    }

    public void removeTask(String name) {
        this.tasks.remove(name);
        this.taskTimes.remove(name);
    }

    public class TaskThread
    extends Thread {
        private ClockTimer ct;

        public TaskThread(ClockTimer ct) {
            this.ct = ct;
        }

        @Override
        public void run() {
            while (this.ct.allExist.isStop(this.ct)) {
                try {
                    TaskThread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                for (Map.Entry nums : this.ct.taskTimes.entrySet()) {
                    if (((ITask)this.ct.tasks.get(nums.getKey())).isStop(this.ct)) {
                        this.ct.taskTimes.remove(nums.getKey());
                        continue;
                    }
                    this.ct.taskTimes.put(nums.getKey(), (Long)nums.getValue() + 1L);
                    if ((Long)this.ct.taskTimes.get(nums.getKey()) < ((ITask)this.ct.tasks.get(nums.getKey())).time(this.ct)) continue;
                    ((ITask)this.ct.tasks.get(nums.getKey())).run(this.ct);
                    this.ct.taskTimes.put(nums.getKey(), 0L);
                }
            }
        }
    }

    public static interface ITask {
        public boolean isStop(ClockTimer var1);

        public void run(ClockTimer var1);

        public long time(ClockTimer var1);
    }

    public static interface IAllExist {
        public boolean isStop(ClockTimer var1);
    }
}

