/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.otyacraftengine.util;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.util.IStringSerializable;
import red.felnull.otyacraftengine.libs.dev.felnull.fnjl.util.FNDataUtil;
import red.felnull.otyacraftengine.libs.dev.felnull.fnjl.util.FNStringUtil;
import red.felnull.otyacraftengine.util.IKSGMath;
import red.felnull.otyacraftengine.util.IKSGStringUtil;

public class IKSGDokataUtil {
    private static final Map<String, String> DOKATAS = new HashMap<String, String>();
    private static final Gson gson = new Gson();
    private static boolean INITED;

    private static void init() {
        if (INITED) {
            return;
        }
        INITED = true;
        try {
            InputStream stream = IKSGDokataUtil.class.getResourceAsStream("/data/otyacraftengine/dokata.gz");
            JsonObject jo = (JsonObject)gson.fromJson((Reader)new InputStreamReader(FNDataUtil.unzipGz(stream)), JsonObject.class);
            jo.entrySet().forEach(n -> DOKATAS.put((String)n.getKey(), FNStringUtil.decodeUTFEscapeSequence(((JsonElement)n.getValue()).getAsString())));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String getDokata(String string) {
        IKSGDokataUtil.init();
        if (DOKATAS.containsKey(string)) {
            return DOKATAS.get(string);
        }
        return "DokataError!!";
    }

    public static String getKusomamirede() {
        return IKSGDokataUtil.getDokata("kusomamire");
    }

    public static String getYattaze() {
        return IKSGDokataUtil.getDokata("yattaze");
    }

    public static String getYaritai() {
        return IKSGDokataUtil.getDokata("yaritai");
    }

    public static String getSenzuri() {
        return IKSGDokataUtil.getDokata("senzuri");
    }

    public static String getKusoKusoKuso() {
        return IKSGDokataUtil.getDokata("kusokusokuso");
    }

    public static String getKusomamire() {
        return IKSGDokataUtil.getDokata("kusomamirede");
    }

    public static String getKusozukiOyajiJisamaBoshu() {
        return IKSGDokataUtil.getDokata("kusozukioyajijisamaboshu");
    }

    public static String getKusomamirede2() {
        return IKSGDokataUtil.getDokata("kusomamirede2");
    }

    public static String getHayakuYariMakuriTaiyo() {
        return IKSGDokataUtil.getDokata("hayakuyarimakuritaiyo");
    }

    public static String getHayakuKusoMamireni() {
        return IKSGDokataUtil.getDokata("hayakukusomamireni");
    }

    public static String getKusomamire2() {
        return IKSGDokataUtil.getDokata("kusomamire2");
    }

    public static String getKusomamire3() {
        return IKSGDokataUtil.getDokata("kusomamire3");
    }

    public static String getKindanSyouJoga() {
        return IKSGDokataUtil.getDokata("kindansyoujoga");
    }

    public static String getKusoOyaji() {
        return IKSGDokataUtil.getDokata("kusooyaji");
    }

    public static String getYarouze() {
        return IKSGDokataUtil.getDokata("yarouze");
    }

    public static String getYagaiDe() {
        return IKSGDokataUtil.getDokata("yagaide");
    }

    public static String getKusomamire4() {
        return IKSGDokataUtil.getDokata("kusomamire4");
    }

    public static String getYaritexe() {
        return IKSGDokataUtil.getDokata("yaritexe");
    }

    public static String getKusomamirede3() {
        return IKSGDokataUtil.getDokata("kusomamirede3");
    }

    public static String getKusomamire5() {
        return IKSGDokataUtil.getDokata("kusomamire5");
    }

    public static String getKuso() {
        return IKSGDokataUtil.getDokata("kuso");
    }

    public static String getKusoDaisuki() {
        return IKSGDokataUtil.getDokata("kusodaisuki");
    }

    public static String getYamaNoNakaDe() {
        return IKSGDokataUtil.getDokata("yamanonakade");
    }

    public static String getYamaNoNakaDe2() {
        return IKSGDokataUtil.getDokata("yamanonakade2");
    }

    public static String getYamaNoNakaDe3() {
        return IKSGDokataUtil.getDokata("yamanonakade3");
    }

    public static String getSibatte() {
        return IKSGDokataUtil.getDokata("sibatte");
    }

    public static String getHonkide() {
        return IKSGDokataUtil.getDokata("honkide");
    }

    public static String getHentaiDaisuki() {
        return IKSGDokataUtil.getDokata("hentaidaisuki");
    }

    public static String getFuroShaNoOssan() {
        return IKSGDokataUtil.getDokata("furoshanoossan");
    }

    public static String getYagaiDe2() {
        return IKSGDokataUtil.getDokata("yagaide2");
    }

    public static String getMakkuro() {
        return IKSGDokataUtil.getDokata("makkuro");
    }

    public static String getYarimakuri() {
        return IKSGDokataUtil.getDokata("yarimakuri");
    }

    public static String getKushizashi() {
        return IKSGDokataUtil.getDokata("kushizashi");
    }

    public static String getRoshutsuShitaZe() {
        return IKSGDokataUtil.getDokata("roshutsushitaze");
    }

    public static String getYarouze2() {
        return IKSGDokataUtil.getDokata("yarouze2");
    }

    public static String getIssyoni() {
        return IKSGDokataUtil.getDokata("issyoni");
    }

    public static String getOkayamade() {
        return IKSGDokataUtil.getDokata("okayamade");
    }

    @Deprecated
    public static String getKurashikiMukaiyamaRoshutsuZuki() {
        return IKSGDokataUtil.ango("20489:25975:21521:23665:38706:20986:22909:12365:12288:25237:31295:32773:65306:22793:24907:12362:12420:12376:32:40:49:50:26376:51:48:26085:65288:28779:65289:50:50:26178:52:50:20998:51:57:31186:41:24179:26085:12392:12363:12399:21521:23665:12395:12394:12363:12394:12363:12356:12369:12394:12356:12363:12425:12394:12354:65374:12290:23713:23665:24066:20869:12398:26132:12398:12488:12509:12473:12398:35023:12398:20844:22290:12398:20415:25152:12391:26397:54:26178:65374:54:26178:51:48:20998:12372:12429:12414:12391:27598:26085:22303:26041:23039:12391:12385:12435:12413:12395:12458:12452:12523:12388:12369:12390:12363:12425:12379:12435:12378:12426:25531:12365:12394:12364:12425:27497:12365:22238:12387:12390:12507:12540:12512:12524:12473:12395:35211:12379:12390:12363:12425:23556:31934:12375:12390:12356:12427:12290:12383:12414:12395:22478:19979:12398:20844:22290:12391:12418:12420:12427:12380:12290:21521:23665:12394:12425:24179:26085:12399:22812:56:26178:12372:12429:12395:12488:12452:12524:12398:27178:12363:12425:23665:12395:12354:12364:12426:12414:12387:12401:12384:12363:12391:23506:12356:12398:12434:12364:12414:12435:12375:12390:27497:12365:22238:12426:12379:12435:12378:12426:25531:12367:12290:19968:32210:12395:38706:20986:12375:12424:12358:12380:12290:26085:26332:26085:12398:26397:12289:21320:21069:53:26178:12395:26089:36215:12365:12434:12375:12390:12356:12388:12418:12398:26381:35013:12391:65288:22320:19979:36275:34955:12539:19971:20998:65405:65438:65422:65438:65437:12539:25163:30002:65404:65388:65410:12539:36234:20013:35084:65289:12391:36554:12391:26093:24029:12398:28014:28010:32773:12364:23621:12427:22303:25163:12395:12420:12387:12390:12365:12383:12290:12371:12371:65299:65374:65300:26085:12399:12379:12435:12378:12426:12418:25531:12363:12378:25105:24930:12375:12390:12356:12383:12398:12391:12289:12418:12358:22303:25163:12395:30528:12356:12383:26178:12363:12425:12385:12435:12413:12364:12403:12435:12403:12435:12395:12394:12387:12390:12375:12414:12387:12390:12356:12427:12290:19971:20998:65405:65438:65422:65438:65437:12363:12425:36234:20013:12398:21069:22402:12428:12434:20986:12375:12385:12435:12413:12395:65431:65420:65438:65397:65394:65433:12434:12388:12369:12368:12385:12421:12368:12385:12421:20113:12431:12379:12394:12364:12425:22303:25163:12434:12362:12426:12383:12290:20170:26085:12399:26397:26089:12367:36215:12365:12390:12289:20363:12398:29242:12373:12435:12434:36814:12360:12395:34892:12387:12383:12425:12356:12388:12418:12398:12467:12452:12531:12521:12531:12489:12522:8213:12398:12477:12501:12449:12540:12395:37202:12434:39135:12425:12387:12390:12363:12425:23517:12390:12356:12383:12398:12391:12289:26089:36895:29242:12373:12435:12434:36215:12371:12375:12383:12425:12302:12354:12354:65281:12354:12435:12383:12363:65281:12393:12387:12363:34892:12367:12435:12363:65311:12303:12392:22768:12434:25499:12369:26397:12363:12425:21448:22793:24907:12434:12375:12395:12356:12363:12435:12363:12392:12356:12356:12289:29242:12373:12435:12434:36554:12395:20055:12379:12390:26093:24029:12398:22303:25163:12398:19979:12414:12391:26469:12383:12289:36884:20013:12391:37202:12420:12425:12499:12540:12523:12420:12425:36023:12356:36796:12435:12391:65281:29242:12373:12435:12395:12431:12375:12398:19971:20998:12392:35084:12434:30528:12369:12373:12379:12390:12289:19971:20998:12398:65409:65388:65391:65400:12399:22730:12375:12390:12356:12390:35084:12364:12414:12427:35211:12360:12395:25104:12427:27096:12395:32048:24037:12434:12375:12390:12356:12427:12290:12431:12375:12398:19971:20998:12418:65409:65388:65391:65400:12434:21462:12426:38500:12356:12390:12356:12427:12375:12385:12435:12413:12364:12383:12387:12383:12425:20024:35211:12360:12395:12394:12427:12424:12358:12395:12375:12390:12356:12427:12290:36023:12356:36796:12435:12384:39135:31975:12399:12392:12426:12354:12360:12378:36554:12395:12362:12356:12390:12289:29242:12373:12435:12395:12289:21448:20154:21069:12391:12420:12426:12414:12367:12425:12435:12363:65311:12392:35328:12387:12383:12425:12302:12431:12375:12418:12385:12435:12413:12364:31435:12387:12390:12383:12414:12425:12435:12380:12424:65281:12399:12424:12420:12425:12435:12363:65281:12303:12371:12398:29242:12373:12435:12399:12431:12375:12392:21516:12376:12391:22909:12365:32773:12384:12375:22793:24907:12391:12394:12435:12391:12418:12420:12427:12363:12425:26368:39640:12384:12290:26397:53:26178:12372:12429:12363:12425:22303:25163:12395:36554:12434:27490:12417:12289:36817:12367:12395:26377:12427:20844:22290:12398:12486:12521:12473:12395:20837:12387:12390:34892:12387:12390:12289:12375:12400:12425:12367:29242:12373:12435:12392:12362:20114:12356:12395:35302:12426:21512:12356:12434:12375:12390:23621:12383:12425:12289:36960:12367:12398:26041:12363:12425:33258:36578:36554:12395:20055:12387:12383:12362:12387:12373:12435:12364:26397:12398:12521:12472:12458:20307:25805:12434:12375:12395:12420:12387:12390:26469:12383:12290:12362:12387:12373:12435:12364:20307:25805:12434:12377:12427:12398:12399:12289:12356:12388:12418:20170:12431:12375:12425:12364:23621:12427:12486:12521:12473:12398:12377:12368:24460:12429:12391:12289:32004:65299:65357:31243:12375:12363:38626:12428:12390:23621:12394:12356:25152:12384:12290:12362:12387:12373:12435:12395:12399:32972:12434:21521:12369:12390:23621:12427:12398:12391:12362:20114:12356:12395:21187:36215:12375:12383:12385:12435:12413:12434:35302:12426:12394:12364:12425:12420:12427:12398:12399:35211:12360:12390:12394:12356:12364:12289:20309:12363:19981:33258:28982:12395:12399:24605:12358:12384:12429:12358:12364:12381:12435:12394:20107:12399:12289:12362:27083:12356:12394:12375:12384:12290:12356:12424:12356:12424:12521:12472:12458:20307:25805:12364:22987:12414:12387:12383:12435:12391:26368:21021:12395:29242:12373:12435:12364:23567:20415:12398:25391:12426:12434:12375:12390:12363:12425:12362:12387:12373:12435:12398:26041:12434:21521:12356:12383:12290:12356:12365:12394:12426:19971:20998:12418:35084:12418:12378:12426:19979:12429:12375:12390:12363:12425:21187:36215:12375:12383:12385:12435:12413:12434:12362:12387:12373:12435:12395:12415:12379:12383:12290:12431:12375:12418:29242:12373:12435:12364:12379:12435:12378:12426:12434:25531:12365:22987:12417:12383:12435:12391:12289:12505:12531:12481:12395:27178:12395:12394:12426:19971:20998:12434:12378:12425:12375:12390:12362:12387:12373:12435:12395:35211:12379:12394:12364:12425:12379:12435:12378:12426:12434:25531:12356:12383:12290:29242:12373:12435:12392:12431:12375:12364:12521:12472:12458:20307:25805:12398:12362:12387:12373:12435:12398:21069:12391:12379:12435:12378:12426:12434:25531:12365:22987:12417:12383:12364:12362:12387:12373:12435:12399:12377:12368:65298:65374:65299:65357:21069:12391:22793:24907:12434:12375:12390:12356:12427:12398:12395:12376:12387:12392:12431:12375:12425:12434:35211:12394:12364:12425:20307:25805:12434:32154:12369:12390:12356:12427:12290:12371:12371:12398:12486:12521:12473:12399:36947:12363:12425:12399:20840:12367:35211:12360:12378:12395:21448:20154:12418:20313:12426:12392:12362:12425:12394:12356:12398:12391:12289:27671:12364:12397:12394:12367:12420:12428:12427:12364:12289:12381:12428:12395:12375:12390:12418:12362:12387:12373:12435:12399:12431:12375:12425:12434:12376:12387:12392:35211:12390:12356:12427:12290:12362:12387:12373:12435:12364:20307:25805:12434:12375:12390:12356:12427:12414:12360:12391:29242:12373:12435:12364:12431:12375:12398:12385:12435:12413:12434:21669:12360:12390:12365:12383:12398:12391:12431:12375:12418:29242:12373:12435:12398:12434:21669:12360:12383:12425:33288:22894:12375:12302:12383:12414:12425:12397:12360:65374:65374:65374:65374:65281:27671:25345:12385:12360:12360:65374:65374:65281:37329:29577:12418:12394:12417:12390:12367:12428:12540:65281:12303:12431:12375:12425:12434:35211:12390:12356:12383:12362:12387:12373:12435:12364:12289:24515:12394:12375:12363:65405:65438:65422:65438:65437:12398:21069:12364:33192:12425:12435:12391:12365:12383:12424:12358:12395:35211:12360:12427:12290:29242:12373:12435:12395:30446:37197:12379:12434:12375:12383:12425:29242:12373:12435:12364:12362:12387:12373:12435:12398:26041:12395:36817:12389:12365:12394:12364:12425:12302:12362:12387:12373:12435:12424:65281:27671:25345:12385:12360:12360:20107:12420:12387:12383:12426:12356:12394:12303:12392:35328:12356:12394:12364:12425:12362:12387:12373:12435:12398:65405:65438:65422:65438:65437:12398:21069:12434:35302:12387:12383:12364:12376:12387:12392:12375:12390:12356:12427:12290:29242:12373:12435:12364:12362:12387:12373:12435:12398:65405:65438:65422:65438:65437:12434:19979:12429:12381:12358:12392:12375:12383:12425:12399:12376:12417:12390:23244:12364:12387:12383:12364:12431:12375:12364:24460:12395:24315:12426:12371:12435:12391:12289:12362:12387:12373:12435:12398:25163:12434:25345:12387:12383:12425:35251:24565:12375:12383:12398:12363:65281:12376:12387:12392:12375:12390:12356:12427:12290:29242:12373:12435:12364:19979:12429:12375:12383:12425:12418:12358:12385:12435:12413:12364:12403:12435:12403:12435:12395:21187:36215:12375:12390:12356:12383:12398:12391:12289:12362:12387:12373:12435:12434:12505:12531:12481:12395:27178:12395:12375:12390:29242:12373:12435:12364:12385:12435:12413:12434:12375:12419:12406:12387:12383:12425:12383:12414:12425:12435:12398:12363:12424:12364:12426:21021:12417:12390:12302:27671:25345:12385:12360:12360:65374:65374:65281:12303:12392:35328:12356:12394:12364:12425:36523:20307:12434:25391:12427:12431:12379:12383:12290:12431:12375:12364:12362:12387:12373:12435:12398:21475:12395:12385:12435:12413:12434:25276:12375:24403:12390:12383:12425:12375:12419:12406:12426:12399:12376:12417:12383:12364:12289:12362:12387:12373:12435:12399:33510:12375:12356:12398:12363:21520:20986:12381:12358:12392:12418:12364:12356:12390:12356:12427:12290:19977:20154:12391:29378:12358:12398:12399:12383:12414:12425:12394:12367:27671:25345:12385:12364:22909:12356:12380:12290:26368:21021:12395:12362:12387:12373:12435:12364:29242:12373:12435:12398:21475:12398:20013:12395:12393:12429:12387:12392:20986:12375:12383:12290:12302:27671:25345:12385:12364:12360:12360:65374:65374:65281:12385:12435:12413:12364:12360:12360:65374:65374:65281:12356:12367:12358:65374:65374:12356:12367:12358:65374:65374:65281:12303:24605:12356:20999:12426:20986:12379:12392:35328:12387:12383:12392:12383:12435:12395:29242:12373:12435:12398:21475:12395:20986:12375:12383:12290:12521:12472:12458:20307:25805:12398:12362:12387:12373:12435:12364:27671:12434:34892:12363:12379:12383:24460:12395:12362:12387:12373:12435:12398:12385:12435:12413:12434:32154:12369:12390:21669:12360:12390:12356:12383:12362:12387:12373:12435:12364:12356:12365:12394:12426:12362:12387:12373:12435:12398:20001:36275:12434:25345:12385:19978:12370:12390:12369:12388:12398:31348:12434:33296:12417:20986:12375:12383:12290:12362:12387:12373:12435:12399:21448:12302:27671:25345:12385:12360:12360:65374:65374:65374:65374:65281:12383:12414:12425:12354:12435:65374:65374:65281:12303:35328:12356:12394:12364:12425:12431:12375:12398:12385:12435:12413:12395:20170:24230:12399:33258:20998:12363:12425:12375:12419:12406:12426:12388:12356:12390:12365:12383:12290:12362:12387:12373:12435:12398:12369:12388:12434:33296:12417:12390:12356:12383:29242:12373:12435:12364:33258:20998:12398:12385:12435:12413:12395:21822:12434:12388:12369:12362:12387:12373:12435:12395:31361:12365:20837:12428:22987:12417:12383:12290:12362:12387:12373:12435:12399:21021:12417:12390:20837:12428:12425:12428:12427:12398:12384:12429:12358:12364:35251:24565:12375:12376:12387:12392:32784:12360:12390:12356:12427:12290:12392:12365:12362:12426:12302:35010:12369:12427:65281:30171:12356:65281:12369:12388:12364:65281:12303:12431:12369:12398:35299:12425:12394:12356:12414:12414:29242:12373:12435:12398:29305:22823:12398:12385:12435:12413:12364:31361:12365:20837:12428:12425:12428:12383:65281:29242:12373:12435:12399:36960:24942:12379:12378:12395:12412:12435:12412:12435:12392:33136:12434:20351:12356:12399:12376:12417:12383:12425:12362:12387:12373:12435:12399:12289:26368:21021:12399:30171:12364:12387:12390:12356:12383:12364:20013:12372:12429:12363:12425:12302:27671:25345:12385:12364:12360:12360:65374:65374:65374:65374:65374:65374:65374:65374:65374:65281:12383:12414:12425:12397:65374:65374:65374:65374:65374:65374:65374:65374:65281:12420:12387:12390:12367:12428:12360:65374:65374:65281:12418:12387:12392:12418:12387:12392:31361:12365:27578:12375:12390:12367:12428:12360:65374:65374:65281:12303:12431:12375:12364:12302:12362:12387:12373:12435:12424:12289:12360:12360:12435:12363:65311:12418:12387:12392:12420:12387:12390:12420:12429:12358:12363:12303:35328:12387:12383:12425:12362:12387:12373:12435:12364:12431:12375:12398:37329:29577:12434:33296:12417:12394:12364:12425:12302:12420:12387:12390:65281:12420:12387:12390:12360:65374:65374:65374:65281:12303:35328:12356:12394:12364:12425:33258:20998:12391:12379:12435:12378:12426:12434:25531:12365:22987:12417:12383:12290:12431:12375:12364:12362:12387:12373:12435:12395:12302:23567:20415:12418:12398:12414:12375:12383:12429:12358:12363:65311:12303:35328:12358:12392:12377:12368:12395:12302:20309:12391:12418:12375:12390:12367:12428:12360:65374:65374:65374:65281:12303:12431:12375:12364:12362:12387:12373:12435:12398:21475:12395:23567:20415:12434:25499:12369:12383:12425:12381:12398:12414:12414:12289:39154:12415:12399:12376:12417:12383:12290:20170:26085:12399:20489:25975:12398:22793:24907:12392:12289:12356:12388:12418:12398:29242:12373:12435:12392:12431:12375:12398:19977:20154:12391:12356:12388:12418:34892:12367:20844:22290:12391:22793:24907:12434:12375:12414:12367:12429:12358:12392:37325:12356:12459:12496:12531:12398:20013:12395:28003:33144:12420:24373:22411:12420:65435:65392:65420:65439:12394:12393:12394:12393:12356:12429:12356:12429:12394:36947:20855:12392:30528:26367:12360:12434:21029:12398:34955:12395:20837:12428:26397:26089:12367:21448:12521:12472:12458:20307:25805:12398:12362:12387:12373:12435:12434:24453:12387:12390:12356:12383:12290:12375:12400:12425:12367:12356:12388:12418:12398:12486:12521:12473:12391:20489:25975:12398:12362:12387:12373:12435:12434:22320:19979:36275:34955:12395:36234:20013:35084:12384:12369:12395:12375:12390:12363:12425:12431:12375:12425:12398:12385:12435:12413:12434:23610:20843:12373:12379:12390:12356:12383:12425:12289:32:12362:12387:12373:12435:12364:12420:12387:12390:26469:12383:12290:12362:12387:12373:12435:12399:12371:12398:21069:12395:29242:12373:12435:12392:20108:20154:12391:36012:12417:12390:12420:12387:12383:12364:12289:12418:12392:12418:12392:12494:12531:27671:12394:12398:12391:12431:12375:12364:12362:12387:12373:12435:12395:12385:12435:12413:12434:21669:12360:12373:12379:12390:12356:32:12427:12398:12434:12289:27178:30446:12391:12481:12521:12483:12392:35211:12383:12384:12369:12391:12521:12472:12458:20307:25805:12434:12420:12426:22987:12417:12383:12290:29242:12373:12435:12399:33288:22894:12375:12383:12398:12363:12289:12521:12472:12458:20307:25805:12398:12362:12387:12373:12435:12398:12377:12368:21069:12398:12505:12531:12481:12391:19971:20998:65405:65438:65422:65438:65437:12418:19979:12429:12375:36234:20013:12418:12399:12378:12375:12390:12289:22320:19979:36275:34955:12384:12369:12395:12394:12426:65394:65409:65404:65438:65400:28003:33144:12434:20309:26412:12418:20837:12428:22987:12417:12289:12381:12398:24460:33258:20998:12391:24373:22411:12434:12375:12450:12492:12473:12496:12531:12489:12434:12375:12289:37749:12434:25499:12369:12390:12363:12425:12431:12375:12398:12459:12496:12531:12398:20013:12395:12363:12366:12434:12375:12414:12387:12390:12363:12425:12302:12431:12375:12364:12356:12367:12425:12289:31966:12364:20986:12381:12358:12395:12394:12387:12390:12363:12425:12289:37749:12434:32368:12428:12387:12390:35328:12387:12390:12418:20986:12377:12394:12424:12290:20170:26085:12399:24505:24213:30340:12395:29378:12358:12392:12371:12434:35211:12379:12383:12356:12435:12420:65281:12303:12431:12375:12364:12302:29242:12373:12435:12364:27671:12364:29378:12358:27096:12434:12415:12390:12420:12427:12424:12303:12375:12400:12425:12367:33258:20998:12391:33145:12434:25545:12435:12391:12356:12383:12364:12289:12384:12435:12384:12435:12392:25105:24930:12364:20986:26469:12394:12367:12394:12387:12390:12365:12383:12398:12384:12429:12358:12289:12521:12472:12458:20307:25805:12398:12362:12387:12373:12435:12398:21069:12391:22320:38754:12395:23567:20415:12434:25746:12365:12394:12364:12425:21816:12387:12390:12356:12427:12364:12289:12356:12365:12394:12426:36215:12365:19978:12364:12427:12392:12362:12387:12373:12435:12395:23567:20415:22615:12428:12398:36523:20307:12391:25265:12365:12388:12356:12383:12364:12362:12387:12373:12435:12399:12385:12435:12413:12395:35302:12425:12428:12390:12418:12376:12387:12392:12375:12390:12356:12427:12290:12381:12398:12358:12385:29242:12373:12435:12364:12362:12387:12373:12435:12398:65405:65438:65422:65438:65437:12434:25244:12365:21462:12426:12362:12387:12373:12435:12398:12385:12435:12413:12434:21669:12360:22987:12417:12383:12290:12362:12387:12373:12435:12418:27671:25345:12385:22909:12356:12398:12363:12358:12394:12426:12394:12364:12425:29242:12373:12435:12398:12385:12435:12413:12434:23610:20843:12375:12390:12356:12427:12290:12431:12375:12425:12364:36817:12389:12356:12390:12363:12425:12377:12368:27178:12391:12362:12387:12373:12435:12395:12385:12435:12413:12434:12394:12417:12373:12379:12390:12420:12387:12383:12290:22235:20154:12391:27671:36949:12356:12395:12394:12426:12394:12364:12425:12289:22320:38754:12434:23567:20415:12434:25746:12365:25955:12425:12375:12394:12364:12425:29378:12387:12383:29242:12373:12435:12399:29539:12398:12424:12358:12395:12431:12417:12365:12394:12364:12425:12362:12387:12373:12435:12398:12385:12435:12413:12434:12375:12419:12406:12387:12390:12356:12427:12290:12431:12375:12425:12364:29242:12373:12435:12434:24460:25163:12395:32283:12426:12431:12375:12364:29242:12373:12435:12398:12385:12435:12413:12434:65436:65394:65428:65392:65420:65438:65431:65404:12391:12383:12383:12365:12399:12376:12417:12383:12425:12289:12362:12387:12373:12435:12364:65435:65392:65407:65400:12434:53:26412:26463:12395:12375:12390:29242:12373:12435:12398:36523:20307:12395:25499:12369:22987:12417:12383:12364:12354:12356:12363:12431:12425:12378:12395:12521:12472:12458:20307:25805:12398:12362:12387:12373:12435:12399:12289:29242:12373:12435:12398:21475:12395:12385:12435:12413:12434:12354:12390:12364:12356:12375:12419:12406:12387:12390:36016:12356:12394:12364:12425:12289:27671:25345:12385:12424:12373:12381:12358:12395:12375:12390:12356:12427:12289:29242:12373:12435:12398:36523:20307:20013:12395:34635:29165:12392:65436:65394:65428:65392:65420:65438:65431:65404:12391:12420:12387:12390:12420:12427:12392:19968:22238:30446:12398:23556:31934:12364:22987:12414:12387:12383:12290:12302:27671:25345:12385:12360:12360:65374:65374:65374:65374:65374:65374:65374:65374:65281:12385:12435:12413:12364:12360:12360:65374:65374:65281:65281:12362:12358:65281:12356:12367:12358:65281:12356:12367:12358:65374:65374:65374:65281:27713:12364:12391:12427:12358:65374:65374:65374:65281:12303:20309:22238:12418:29539:12398:36960:21536:12360:12415:12383:12356:12395:35328:12356:27713:12392:20854:12398:24460:12377:12368:12395:23567:20415:12434:20986:12375:12390:12375:12414:12387:12383:12290:26152:26085:12289:27700:23798:20013:22830:20844:22290:12398:20415:25152:12398:27178:12398:12502:12525:12483:12463:12398:25152:12391:12289:19971:20998:12474:12508:12531:12434:33073:12366:25448:12390:22320:19979:36275:34955:12395:25163:30002:12471:12515:12484:12391:12385:12435:12413:12395:65431:65420:65438:65397:65394:65433:12434:12383:12387:12407:12426:12388:12369:12390:12385:12435:12413:12434:12464:12481:12515:12464:12481:12515:12395:12375:12390:12379:12435:12378:12426:12434:12363:12356:12390:12356:12383:12425:12289:29242:12373:12435:12364:20108:20154:23492:12387:12390:26469:12383:12290:32:12431:12375:12364:22768:12434:20986:12375:12394:12364:12425:12304:12354:12354:65374:65374:12385:12435:12413:12364:12360:12360:65374:27671:25345:12364:12360:12360:65374:12305:12420:12426:12414:12367:12387:12390:12356:12383:12364:30446:12398:21069:12395:26469:12390:12289:12304:27671:25345:12360:12360:12363:9794:12383:12414:12425:12435:12363:12305:12356:12356:12394:12364:12425:35302:12387:12390:26469:12383:12539:26397:12289:65302:26178:12372:12429:12363:12425:12356:12388:12418:12398:20844:22290:12395:34892:12387:12383:12290:23713:23665:39365:12363:12425:36817:12356:12371:12398:20844:22290:12395:12399:24180:37197:12398:12381:12428:12418:12363:12394:12426:24180:12398:34892:12387:12383:12362:12387:12373:12435:12420:29242:12373:12435:12398:28014:28010:32773:12364:22810:12367:20303:12435:12391:23621:12427:12290:20844:22290:12395:30528:12356:12383:26178:12399:12414:12384:65302:26178:21069:12384:12364:12289:39376:36554:22580:12395:36554:12434:27490:12417:12390:12356:12388:12418:36890:12426:12395:22320:19979:36275:34955:12289:19971:20998:12474:12508:12531:12395:25163:30002:12471:12515:12484:12392:35328:12358:12473:12479:12452:12523:12391:20844:22290:12398:12486:12521:12473:12395:21521:12363:12387:12390:20415:25152:12398:26041:12363:12425:27497:12356:12390:34892:12387:12383:12425:12289:29242:12373:12435:12364:20415:25152:12398:36523:20307:38556:23475:32773:29992:12398:20415:25152:20013:12391:12289:20024:35064:12395:12394:12387:12390:20307:12434:25325:12356:12390:12356:12383:12290:12302:12362:12362:12358:12289:29242:12373:12435:12289:20307:12289:27927:12362:12358:12392:12435:12363:65311:23506:12358:12394:12356:12363:65311:12303:12392:22768:12434:12363:12369:12390:12420:12427:12392:12289:12302:12418:12358:26262:12363:12356:26085:12395:12394:12387:12383:12363:12425:12398:12362:65374:65374:12303:12392:12431:12375:12398:26041:12434:12481:12521:12483:12392:35211:12390:12363:12425:31572:12360:12383:12290:12371:12398:29242:12373:12435:12399:12424:12367:35211:12363:12369:12427:29242:12373:12435:12391:20309:22238:12363:12385:12435:12413:12434:23610:20843:12375:12390:12379:12435:12378:12426:12398:25531:12365:12354:12356:12434:12420:12387:12383:20107:12364:12354:12427:12435:12391:12289:12302:29242:12373:12435:12424:12289:20170:26085:12399:38632:12394:12435:12391:24460:12391:12379:12435:12378:12426:25531:12363:12435:12363:65311:27671:25345:12385:12360:12360:20107:12420:12425:12435:12363:65281:37202:25345:12387:12390:12365:12383:12369:12435:12398:12362:65374:65374:12303:12392:35328:12387:12390:12420:12387:12383:12425:12302:12362:12362:12289:12420:12427:12363:12398:12362:65374:65374:21448:22823:21218:12391:12385:12435:12413:12375:12419:12406:12426:12354:12356:12377:12427:12363:12398:12362:12303:12392:22768:12434:22823:12365:12367:12375:12390:20024:35064:12398:12385:12435:12413:12434:12371:12377:12387:12390:35211:12379:12383:12290:12302:12486:12521:12473:12395:12362:12427:12363:12425:21448:12354:12392:12391:12394:65281:12303:12392:35328:12356:12289:12431:12375:12399:12486:12521:12473:12395:30528:12356:12383:12425:65298:20154:12398:12362:12387:12373:12435:12364:12486:12521:12473:12398:12505:12531:12481:12434:12486:12540:12502:12523:12364:12431:12426:12395:12375:12390:37202:12434:39154:12435:12391:12356:12383:12435:12391:12289:12302:12362:12362:12289:12362:12387:12373:12435:12425:12354:26397:12363:12425:37202:30427:12363:12356:12289:12360:12360:12398:12362:65374:65374:12431:12375:12418:37202:25345:12387:12390:26469:12383:12435:12391:20210:38291:12395:12356:12428:12435:12363:12356:12420:65281:12303:12392:35328:12356:12394:12364:12425:22320:12409:12383:12395:19971:20998:12398:12481:12515:12483:12463:12434:38283:12356:12383:12414:12414:24231:12387:12383:12364:12418:12358:12385:12435:12413:12364:12366:12435:12366:12435:12395:21187:36215:12375:12390:12356:12427:12289:12362:12387:12373:12435:12383:12385:12392:35441:12434:12375:12390:12356:12383:12425:20808:12411:12393:12398:29242:12373:12435:12364:36234:20013:35084:12384:12369:12391:12473:12522:12483:12497:12434:23653:12356:12390:12486:12521:12473:12395:20837:12387:12390:26469:12383:12290:12302:12431:12375:12434:35211:12427:12392:12431:12375:12398:27178:12395:24231:12426:12289:37202:12434:39154:12415:12394:12364:12425:12431:12375:12398:19971:20998:12395:25163:12434:31361:12387:36796:12435:12391:12363:12425:12302:12354:12354:12373:12435:12424:12289:12385:12435:12413:12364:12403:12435:12403:12435:12289:12420:12435:12369:12289:12431:12375:12364:25531:12356:12383:12429:12363:65311:35064:12395:12394:12387:12390:12415:12303:12431:12375:12364:22320:19979:36275:34955:12392:19971:20998:12434:33073:12356:12384:12425:27531:12426:12398:20108:20154:12398:21069:12391:23610:20843:12434:22987:12417:12383:12290:12302:12362:12362:65374:65374:12289:12385:12435:12413:37202:12376:12419:12362:12356:12375:12356:12385:12435:12413:12376:12419:12398:12362:65374:65374:12303:12392:22823:12365:12394:22768:12391:12420:12426:22987:12417:12383:12398:12391:12289:12431:12375:12418:65302:65305:12395:12394:12426:29242:12373:12435:12398:12385:12435:12413:12434:23610:20843:12375:12390:12420:12387:12383:12425:21187:36215:12375:12390:12365:12383:12290:12302:12354:12354:12354:65342:65342:65374:65374:12383:12414:12425:12397:12360:12424:65374:65374:12385:12435:12413:12364:27671:25345:12385:12360:12360:12424:12362:65374:65374:37329:29577:12364:12365:12418:12385:12360:12360:12424:12362:65374:12303:12302:12431:12375:12418:12360:12360:12424:12362:12369:12388:12398:31348:12394:12417:12425:12428:12383:12425:12383:12414:12425:12435:12380:12424:65374:65374:12303:12394:12393:21329:29477:12394:22768:12434:12384:12375:12414:12367:12426:12394:12364:12425:27531:12426:12398:20108:20154:12395:12418:12362:12387:12373:12435:12424:12385:12435:12413:12375:12419:12406:12425:12379:12390:12367:12428:65374:65374:12383:12398:12416:12424:65281:12394:12393:22768:12434:33618:12370:12394:12364:12425:35328:12387:12390:12474:12508:12531:12398:19978:12363:12425:12385:12435:12413:12395:35302:12387:12390:12420:12427:12392:21187:36215:12375:12366:12435:12366:12435:12395:12394:12387:12390:12356:12427:12290:23713:23665:24066:12398:20170:26449:12395:26377:12427:12289:22320:19979:36947:12399:26397:26089:12367:25955:27497:12395:34892:12367:29242:12373:12435:36899:20013:12364:27598:26085:54:26178:12372:12429:12395:53:65374:54:20154:36890:12427:12290:12371:12371:12391:12379:12435:12378:12426:12434:12420:12387:12390:35211:12379:12383:12425:33288:22894:12377:12427:12290:26397:12289:54:26178:21069:12395:12431:12375:12392:12418:12358:19968:20154:54:48:12368:12425:12356:12398:22793:24907:12398:29242:12373:12435:12392:20986:12363:12369:12383:12290:29242:12373:12435:12399:34892:12367:21069:12363:12425:33288:22894:12375:12390:12385:12435:12413:12364:12403:12435:12403:12435:12395:12394:12387:12390:12363:12425:19971:20998:65405:65438:65422:65438:65437:12363:12425:20986:12375:12390:33258:20998:12391:35302:12387:12390:12356:12427:12289:12431:12375:12418:30171:12356:12368:12425:12356:21187:36215:12375:12390:12356:12427:12290:36817:12367:12395:36554:12434:20572:12417:49:48:48:109:12368:12425:12356:27497:12365:22320:19979:36947:12395:20837:12387:12383:12290:22320:19979:36947:12399:39080:12364:20313:12426:36890:12425:12394:12356:12398:12363:20313:12426:23506:12367:28961:12356:12290:29242:12373:12435:12399:30528:12367:12394:12426:19971:20998:12434:33073:12366:25448:12390:36234:20013:12392:22320:19979:36275:34955:12384:12369:12395:12394:12426:12289:12431:12375:12398:12385:12435:12413:12434:12375:12419:12406:12426:12395:12367:12427:12290:12431:12375:12418:19971:20998:12434:33073:12366:12289:36234:20013:12418:21462:12426:22320:19979:36275:34955:12384:12369:12391:29242:12373:12435:12395:12375:12419:12406:12425:12379:12383:12290:12375:12400:12425:12367:12375:12383:12425:29242:12373:12435:12364:23517:36578:12406:12435:12391:12431:12375:12398:12385:12435:12413:12434:12369:12388:12398:31348:12395:65431:65420:65438:65397:65394:65433:12434:22615:12426:25276:12375:36796:12435:12391:12420:12387:12383:12425:12289:27671:25345:12385:22909:12356:12398:12363:12289:29242:12373:12435:12398:12385:12435:12413:12399:12378:12427:12378:12427:12395:12394:12387:12390:12356:12427:12290:12369:12388:12434:12364:12435:12364:12435:25496:12387:12390:12420:12387:12390:12356:12383:12425:12289:36275:38899:12364:32862:12371:12360:12390:12384:12435:12384:12435:12395:36817:12389:12356:12390:12365:12383:12290:29242:12373:12435:12399:65288:12385:12435:12413:12364:12365:12418:12385:12360:12360:65374:65374:65374:65281:12383:12414:12425:12397:12360:65374:65374:65281:65289:12392:12424:12364:12387:12390:12356:12427:12290:36275:38899:12364:12377:12368:20596:12395:26469:12390:35282:12434:26354:12364:12387:12383:12290:12431:12375:12425:12398:22793:24907:12364:20024:35211:12360:12395:12394:12387:12390:12356:12427:12290:65288:12362:12414:12360:12425:12289:26397:12363:12425:30007:21516:22763:12391:22793:24907:12363:12354:65374:65374:65281:12394:12395:12420:12387:12392:12435:12376:12419:65281:65289:20013:12398:29242:12373:12435:12364:35328:12358:12398:12391:12431:12375:12364:65288:12379:12435:12378:12426:12434:12420:12387:12392:12435:12420:12289:29242:12373:12435:12425:12395:35211:12390:12418:12425:12356:12392:12362:12390:12394:65281:65289:35328:12387:12383:12425:29242:12373:12435:12364:12377:12368:20596:12414:12391:12365:12383:12435:12391:12431:12375:12364:12385:12435:12413:12434:29242:12373:12435:12395:31361:12365:20837:12428:12383:12425:29242:12373:12435:12399:33258:20998:12391:12379:12435:12378:12426:12434:25531:12365:12289:12424:12364:12426:12394:12364:12425:23556:31934:12375:12390:12375:12414:12387:12383:12290:12431:12375:12418:25244:12356:12390:29242:12373:12435:12398:38996:12395:27713:12434:12383:12387:12407:12426:12392:12363:12369:12289:12381:12398:24460:23567:20415:12434:38957:12363:12425:12363:12369:12390:35211:12379:12383:12290:21448:12420:12426:12383:12356:12380:12290:22793:24907:12364:12392:32629:12425:12428:12394:12364:12425:12418:65281:65281:26152:22812:12363:12425:12289:12371:12371:25968:26085:12363:12435:12399:12394:12395:12418:12394:12363:12387:12383:12398:12391:12289:26089:12417:12395:24067:22243:12395:20837:12387:12390:12356:12383:12425:12302:12500:12531:12509:65374:65374:12531:12303:12392:29572:38306:12398:21628:12403:37428:12398:38899:12289:12385:12423:12358:12393:33391:12356:25152:12394:12398:12395:12392:24605:12356:12394:12364:12425:12418:36234:20013:35084:12434:12388:12369:12390:12363:12425:12452:12531:12479:12540:12507:12531:12391:12302:12393:12385:12425:12373:12414:12391:12377:12363:65311:12303:12392:12393:9675:12385:12419:12435:12302:26032:32862:23627:12391:12377:12364:65374:65374:12303:12392:12452:12531:12479:12540:12507:12531:12398:21521:12371:12358:12363:12425:12289:8230:8230:22256:12387:12383:12394:65281:12288:12379:12435:12378:12426:12398:36884:20013:12384:12387:12383:12435:12391:12289:12385:12435:12413:12364:12403:12435:12403:12435:12395:21187:36215:12375:12390:36234:20013:12434:31361:12365:19978:12370:12390:12356:12427:12387:12390:12398:12395:12539:12539:12539:12539:12539:65281:12398:12382:12365:31348:12363:12425:12415:12383:12425:21021:12417:12390:35211:12427:12424:12358:12394:38996:12398:29242:12373:12435:12364:20309:12363:12434:25345:12387:12390:12383:12387:12390:12356:12427:12290:12414:12354:12371:12398:12414:12414:12391:12418:12356:12356:12363:12392:24605:12356:12394:12364:12425:12289:12489:12450:12434:38283:12369:12390:12420:12387:12383:12289:12302:12377:12415:12414:12379:12435:12397:12289:12371:12428:12363:12425:39080:21570:12395:20837:12429:12358:12392:24605:12387:12390:12356:12414:12375:12383:12363:12425:12289:12394:12395:12363:24481:29992:12391:12377:12363:65311:12303:12392:12393:9675:12385:12419:12435:12290:12381:12375:12383:12425:29242:12373:12435:12364:12302:9675:9675:26032:32862:12391:12377:12364:12289:49:12534:26376:12391:12418:12424:12429:12375:12356:12398:12391:12392:12387:12390:12367:12428:12414:12379:12435:12363:65311:12303:12392:29242:12373:12435:12364:35328:12358:12290:39080:21570:12398:28271:12364:20986:12390:12356:12383:12398:12391:12289:29242:12373:12435:12395:12302:12385:12423:12387:12392:12414:12387:12390:39080:21570:12434:27490:12417:12390:12367:12427:12363:12425:12289:12414:12354:12381:12371:12395:24231:12387:12390:23041:12434:12414:12387:12390:12390:12303:12392:12393:9675:12385:12419:12435:12290:12302:12399:12356:12289:12431:12363:12426:12414:12375:12383:12303:12392:29242:12373:12435:12364:12431:12375:12398:36234:20013:35084:12398:21069:12434:12385:12425:12387:12392:35211:12394:12364:12425:35328:12358:12290:39080:21570:12434:27490:12417:12395:12356:12387:12383:12418:12398:12398:30456:22793:12431:12425:12378:12385:12435:12413:12399:12403:12435:12403:12435:12398:12414:12414:12391:36234:20013:12434:12388:12365:12354:12370:12390:12356:12427:12289:12431:12374:12392:12422:12427:12405:12435:12395:12375:12390:29242:12373:12435:12398:21069:12391:31435:12390:12402:12374:12395:12394:12426:29242:12373:12435:12398:35500:26126:12434:32862:12356:12383:12425:12289:29242:12373:12435:12399:12431:12375:12398:12385:12435:12413:12364:12403:12367:12403:12367:12375:12390:12356:12427:12398:12434:12385:12425:12385:12425:12415:12394:12364:12425:12289:27735:12434:12363:12356:12390:35500:26126:12434:12375:12390:12356:12427:12290:12431:12374:12392:12385:12435:12413:12364:35211:12360:12427:12424:12358:12395:12375:12390:12420:12387:12383:12290:29242:12373:12435:12399:12375:12365:12426:12395:38989:12395:25163:12434:12420:12387:12383:12426:12375:12394:12364:12425:49:12534:26376:12392:12387:12390:12367:12428:12392:19968:29983:25080:21629:12375:12419:12409:12387:12390:12356:12427:12290:12431:12375:12364:29242:12373:12435:12395:12302:29242:12373:12435:12424:12289:12392:12387:12390:12420:12387:12390:12418:12356:12356:12424:65281:12303:12392:35328:12387:12390:12420:12387:12383:12425:12377:12368:26360:39006:12434:20986:12375:12390:12365:12383:12290:12508:12540:12523:12506:12531:12391:21517:21069:12392:20303:25152:12434:26360:12367:26178:12395:12399:23436:20840:12395:21187:36215:12375:12383:12385:12435:12413:12364:35211:12360:12390:12356:12427:12290:29242:12373:12435:12364:12302:12362:12395:12356:12385:12419:12435:12289:12385:12435:12413:12364:31435:27966:12395:12394:12387:12390:12414:12377:12424:12303:12392:35328:12387:12383:12398:12391:12289:12302:12354:12354:65374:29242:12373:12435:12364:26469:12427:21069:12395:12379:12435:12378:12426:12434:25531:12371:12358:12392:24605:12387:12390:12394:12385:12435:12413:12434:12375:12372:12356:12390:12356:12383:12435:12384:12290:12418:12358:23569:12375:12391:34892:12367:12392:12371:12384:12387:12383:12435:12384:12303:12392:35328:12387:12390:12363:12425:12356:12365:12394:12426:29242:12373:12435:12398:25163:12434:12388:12363:12435:12391:12363:12425:12385:12435:12413:12395:35302:12425:12379:12390:12420:12387:12383:12290:12381:12375:12383:12425:12302:12431:12383:12375:12364:12371:12377:12387:12390:12420:12426:12414:12375:12423:12358:12363:65311:12303:12392:35328:12387:12390:12363:12425:12385:12435:12413:12434:12371:12377:12426:12384:12375:12383:12364:12289:12418:12358:33288:22894:12398:38914:28857:12395:36948:12375:12390:12356:12383:12383:12417:12289:29242:12373:12435:12398:25163:12391:24605:12356:20999:12426:27713:12434:12393:12429:12393:12429:12392:20986:12375:12390:12375:12414:12387:12383:12290:29242:12373:12435:12362:21069:12434:35302:12387:12390:12415:12383:12425:29242:12373:12435:12398:20485:12418:21187:36215:12375:12390:12356:12383:12398:12391:12289:25531:12356:12390:12420:12387:12383:12425:12289:12431:12375:12398:25163:12395:12384:12375:12383:12290:26368:39640:12398:21942:26989:12510:12531:12384:12424:12392:35328:12387:12383:12425:31505:12387:12390:12356:12383:12290:20170:26085:12399:12289:24859:29356:12398:12385:12419:9675:12392:19968:32210:12395:20181:20107:12363:12425:12363:12360:12387:12390:12363:12425:12289:25955:27497:12375:12390:12356:12383:12425:12289:12356:12388:12418:12398:20844:22290:12398:12505:12531:12481:12395:65302:65296:36942:12366:12398:12362:12387:12373:12435:12364:23517:12390:12356:12383:12539:12539:12539:12414:12354:65374:37202:12395:37204:12387:12390:12363:12425:23517:12390:12356:12427:12398:12363:12392:12289:24605:12387:12383:12425:36817:12367:12414:12391:34892:12387:12383:12425:12289:12474:12508:12531:12434:27526:12435:12393:12396:12356:12391:12375:12414:12387:12390:12289:29255:36275:12395:12420:12387:12392:12363:12363:12387:12390:12356:12427:31243:24230:12391:12289:12501:12522:12481:12531:12395:12394:12387:12390:12356:12383:12290:12431:12375:12364:12289:12385:12419:9675:12392:36817:12367:12414:12391:34892:12387:12383:12425:12289:27671:12364:12388:12356:12383:12415:12383:12356:12384:12364:12289:19968:21521:12395:12385:12435:12413:12434:12375:12414:12362:12358:12392:12375:12394:12356:65281:65281:12414:12354:65374:12393:12435:12394:12385:12435:12413:12363:12394:12354:65374:65374:12387:12390:24605:12356:12394:12364:12425:12505:12531:12481:12398:12377:12368:12381:12400:12414:12391:34892:12367:12392:12289:12385:12435:12413:12364:12403:12435:12403:12435:12395:21187:36215:29366:24907:12391:12289:33258:20998:12391:21822:12434:12388:12369:12390:12379:12435:12378:12426:12434:25531:12356:12390:12356:12427:12290:27178:12434:35211:12383:12425:12289:21448:12371:12398:12362:12387:12373:12435:12418:12408:12435:12378:12426:25531:12356:12390:12356:12427:12362:12387:12373:12435:12434:12415:12394:12364:12425:12289:33258:20998:12391:12420:12387:12390:12356:12427:12435:12391:12289:12381:12400:12395:34892:12387:12390:12289:12302:12362:12387:12373:12435:12424:65281:12408:12435:12378:12426:25531:12356:12392:12435:12363:12354:65374:12289:27671:25345:12385:12360:12360:12363:12354:65374:65311:65311:12303:12387:12390:32862:12356:12390:12415:12383:12425:12289:65288:12354:12354:65374:65374:65374:27671:25345:12385:12360:12360:12394:12354:65374:65374:12289:12354:12354:12373:12435:12398:12385:12435:12413:12289:21560:12356:12383:12356:12435:12420:12354:65374:41:12387:12390:35328:12358:12290:21608:12426:12395:12362:12387:12373:12435:12364:20108:20154:12375:12363:23621:12394:12356:12398:12434:30906:35469:12375:12390:12289:12362:12387:12373:12435:12398:21475:20803:12395:12385:12435:12413:12418:12387:12390:12356:12387:12390:12420:12427:12392:12289:12400:12387:12367:12426:12392:12375:12419:12406:12425:12428:12383:12290:12302:12354:12354:65374:65374:65374:27671:25345:12385:12356:12356:65374:65374:12303:24605:12431:12378:22768:12364:20986:12381:12358:12394:12411:12393:12289:12385:12435:12413:12434:21560:12358:12398:12364:12358:12414:12356:12435:12420:65281:65281:27178:12434:35211:12383:12425:12381:12398:12362:12387:12373:12435:12364:20170:24230:12399:12289:12431:12375:12434:12375:12419:12406:12387:12390:12356:12427:12362:12387:12373:12435:12398:12385:12435:12413:12434:33296:12417:12390:12356:12427:12435:12420:65281:65281:12418:12358:12371:12435:12394:25152:12391:65299:65328:12394:12435:12390:12392:24605:12356:12394:12364:12425:12418:12365:12435:12384:12414:12414:12391:33296:12417:12373:12379:12383:12290:12362:12387:12373:12435:12364:20108:20154:12391:12420:12427:12398:12434:35211:12379:12390:12367:12428:12383:12435:12391:12424:12363:12387:12383:12424:12290:12381:12428:12395:12375:12390:12418:12360:12360:12385:12435:12413:12420:12387:12383:12394:12354:65374:65374:65281:65281:22269:36947:51:48:21495:32218:12398:23713:23665:30476:29577:37326:24066:27084:12534:21407:12395:12354:12427:12289:36947:12398:39365:12398:19968:30058:22885:12398:20415:25152:12391:12289:23567:20415:12434:12375:12390:12356:12383:12425:12431:12375:12398:22909:12365:12394:65408:65394:65420:65439:12398:12362:12387:12373:12435:12364:20415:25152:12395:20837:12387:12390:26469:12383:12290:12393:12371:12363:12398:65412:65431:65391:65400:12398:36939:36578:25163:12415:12383:12356:12384:12289:24180:40802:12399:54:48:21069:12392:35328:12358:25152:12363:12394:12290:21106:12392:12371:12429:12371:12429:12392:22826:12387:12390:12356:12427:12415:12383:12356:12384:12375:12289:36523:38263:12418:49:54:53:12368:12425:12356:12391:36969:24403:12395:20024:12356:38996:12434:12375:12390:12356:12390:22909:12356:24863:12376:12384:12290:12431:12375:12398:65299:12388:12368:12425:12356:38626:12428:12383:25152:12398:23567:20415:22120:12391:23567:20415:12434:12375:12384:12375:12383:12290:12431:12375:12364:27178:30446:12391:12362:12387:12373:12435:12398:26041:12434:35211:12383:12425:12362:12387:12373:12435:12418:12431:12375:12398:26041:12434:35211:12390:12356:12383:12398:12391:12431:12375:12364:23567:20415:12434:12377:12435:12384:12414:12414:12289:12385:12435:12413:12434:20986:12375:12390:12363:12425:19971:20998:12474:12508:12531:12434:19979:12429:12375:12390:36234:20013:35084:12434:12362:12387:12373:12435:12395:35211:12360:12427:27096:12395:12375:12390:19968:26086:24341:12365:25244:12356:12390:12363:12425:12362:12418:12416:12429:12395:36234:20013:12434:32224:12417:12394:12362:12375:12390:35211:12379:12390:12420:12387:12383:12425:12289:12362:12387:12373:12435:12399:23567:20415:12434:12375:12394:12364:12425:12431:12375:12398:12385:12435:12413:12392:35084:12434:12376:12387:12392:12415:12390:12356:12383:12435:12391:12289:12385:12435:12413:12364:21187:36215:12375:12383:12290:12381:12398:12414:12414:12431:12374:12392:12289:12362:12387:12373:12435:12395:21187:36215:12375:12383:12385:12435:12413:12364:35211:12360:12427:27096:12395:12375:12390:35084:12398:20013:12408:12375:12414:12356:12289:19971:20998:12474:12508:12531:12434:19978:12370:12390:12363:12425:12362:12387:12373:12435:12398:26041:12434:35211:12383:12425:12289:12362:12387:12373:12435:12399:23567:20415:12364:32066:12431:12387:12383:12398:12395:12431:12375:12398:26041:12434:21521:12356:12383:12290:12362:12387:12373:12435:12398:12385:12435:12413:12364:12403:12435:12403:12435:12395:12394:12387:12390:12356:12383:12364:12289:12431:12374:12392:12375:12425:12435:25391:12426:12434:12375:12390:23567:20415:22120:12398:24460:12395:12354:12427:12289:22823:20415:25152:12395:20837:12426:12489:12450:12434:38283:12369:12383:12414:12414:12362:12387:12373:12435:12398:24460:12391:19971:20998:12392:36234:20013:35084:12434:38477:12429:12375:12385:12435:12413:12395:12521:12502:12458:12452:12523:12434:12388:12369:12390:12379:12435:12378:12426:12434:25531:12356:12390:12356:12383:12425:12362:12387:12373:12435:12418:20415:25152:12398:20013:12395:20837:12387:12390:12365:12390:12289:12356:12365:12394:12426:12431:12375:12398:12385:12435:12413:12434:21669:12360:12390:23610:20843:12375:12384:12375:12383:12398:12391:12362:12387:12373:12435:12434:31435:12383:12379:12362:12387:12373:12435:12398:12385:12435:12413:12418:12375:12419:12406:12387:12390:12420:12387:12383:12290:50:48:20998:12368:12425:12356:12418:12375:12419:12406:12426:21512:12356:12434:12375:12390:12363:12425:12362:12387:12373:12435:12364:24460:12434:21521:12356:12383:12398:12391:12431:12375:12398:12385:12435:12413:12434:24605:12356:20999:12426:12362:12375:12371:12435:12391:12420:12387:12383:12425:22823:12365:12394:22768:12434:20986:12375:27875:12365:20986:12375:12383:12398:12391:12431:12375:12418:20313:35336:12395:33288:22894:12375:12289:12362:12387:12373:12435:12398:12369:12388:12398:31348:12395:12385:12435:12413:12434:31361:12365:19978:12370:12390:12420:12387:12383:12290:12375:12400:12425:12367:12375:12383:12425:12362:12387:12373:12435:12364:65288:12356:12367:65374:65374:65374:65374:65374:65374:65374:65374:65374:65289:12392:35328:12356:12290:12431:12375:12398:25163:12398:20013:12395:22823:37327:12398:31934:28082:12434:25746:12365:25955:12425:12375:12383:12290:12431:12375:12418:12362:12387:12373:12435:12398:31348:12395:24605:12356:20999:12426:27880:12366:12371:12435:12391:12420:12387:12383:12290:21448:26469:36913:26469:12427:12425:12375:12356:12398:12391:20170:24230:12399:65412:65431:65391:65400:12398:20013:12391:12420:12429:12358:12392:35328:12387:12390:12356:12383:12290:12385:12435:12413:12395:65431:65420:65438:65397:65394:65433:12434:12383:12387:12407:12426:12388:12369:12289:12369:12388:12398:12354:12394:12395:65400:65432:65392:65425:12434:22615:12426:29305:22823:12398:24373:22411:12434:20837:12428:12390:20415:25152:12398:21069:12391:12379:12435:12378:12426:12434:25531:12356:12390:12356:12383:12290:12375:12400:12425:12367:12369:12388:12398:31348:12398:24373:22411:12434:20986:12375:20837:12428:12375:12390:12356:12383:12425:12289:22338:12398:19979:12363:12425:29242:12373:12435:12364:19978:12364:12387:12390:26469:12427:12398:12364:35211:12360:12383:12289:12431:12375:12399:33288:22894:12375:12390:20170:12395:12418:12356:12365:12381:12358:12395:12394:12387:12383:12364:12289:25105:24930:12375:12390:29242:12373:12435:12398:30446:12398:21069:12391:20986:12375:12390:12420:12429:12358:12392:24605:12387:12390:12375:12400:12425:12367:12379:12435:12378:12426:12434:27490:12417:12385:12435:12413:12434:36215:12390:12383:12414:12414:20415:25152:12398:20013:12434:12358:12429:12358:12429:12375:12390:12356:12383:12290:29242:12373:12435:12364:50:48:65374:51:48:109:12368:12425:12356:12395:36817:12389:12356:12383:26178:12395:20415:25152:12363:12425:20986:12390:20837:21475:12395:23517:36578:12435:12391:12363:12425:24373:22411:12434:20986:12375:20837:12428:12375:12394:12364:12425:12385:12435:12413:12434:24605:12356:20999:12426:25531:12356:12390:12356:12383:12425:12289:27671:25345:12385:12364:39640:12406:12426:22768:12364:20986:12427:12290:65288:12354:12354:65374:65374:65374:65374:65281:27671:25345:12385:12360:12360:65374:65374:65281:12369:12388:12364:30140:12367:12358:65374:65374:65281:12385:12435:12413:12364:27671:25345:12385:12360:12360:12424:12362:65374:65374:65281:65289:29242:12373:12435:12364:12377:12368:20596:12395:36817:12389:12356:12390:26469:12383:12290:12377:12368:12381:12371:12398:35282:12434:26354:12364:12428:12400:12418:12358:12431:12375:12398:22793:24907:12364:20024:35211:12360:12384:12290:20170:12395:12418:12356:12365:12381:12358:12384:12290:29242:12373:12435:12364:35282:12434:26354:12364:12387:12390:20415:25152:12398:26041:12434:35211:12390:19968:30636:36275:12434:20572:12417:12289:12431:12375:12398:12379:12435:12378:12426:12434:12376:12387:12392:35211:12390:12356:12427:12431:12375:12364:65288:12354:12354:27671:25345:12385:12360:12360:65374:65374:65281:65289:12392:35328:12356:12394:12364:12425:12379:12435:12378:12426:12434:32154:12369:12390:12356:12390:12289:29242:12373:12435:12398:26041:12434:35211:12394:12364:12425:65288:29242:12373:12435:12424:12289:27671:25345:12385:12360:12360:12382:65374:65374:65281:12418:12358:12356:12367:12382:65281:65289:29242:12373:12435:12398:21069:12391:24605:12356:20999:12426:24373:22411:12434:31361:12387:36796:12415:12385:12435:12413:12363:12425:27713:12434:20986:12375:12383:22303:26332:26085:12398:22812:12363:12425:12289:12393:9675:12385:12419:12435:12398:12473:12490:12483:12463:12391:12418:12289:35064:31085:12426:65311:12539:12539:12539:12539:35084:12497:12540:12486:12451:12540:12384:12290:12362:23458:12373:12435:21313:25968:20154:12364:36234:20013:35084:19968:19969:12391:12459:12521:12458:12465:12420:12480:12531:12473:12434:27005:12375:12435:12391:12367:12428:12383:12290:29421:12356:24215:20869:12391:12399:26262:25151:12434:24369:12395:12375:12390:12418:26257:12356:24863:12376:12364:12354:12427:12290:24180:37197:12398:65288:55:53:27507:12384:12392:26412:20154:12364:35328:12358:65289:26041:12364:12459:12521:12458:12465:12434:19968:32210:12395:27468:12387:12390:12363:12425:12480:12531:12473:12395:35480:12387:12390:12365:12383:12290:12480:12531:12473:12398:36884:20013:12395:29242:27096:12398:25163:12364:36234:20013:35084:12398:20013:12408:20837:12387:12390:12365:12390:24858:24687:12434:12388:12363:12435:12391:26469:12383:12290:36234:20013:12398:20013:12391:29242:27096:12398:12385:9675:12413:12418:23041:12365:12426:31435:12387:12390:12356:12427:12398:12364:12424:12367:35299:12427:12290:12362:23458:12373:12435:12398:25163:12364:20108:20154:12398:36234:20013:12434:12399:12378:12375:12390:12375:12414:12387:12383:12290:12362:20114:12356:12395:12385:9675:12413:12434:12354:12431:12379:12383:12414:12414:12398:12480:12531:12473:12399:21050:28608:12364:12354:12387:12390:12383:12414:12425:12394:12356:12290:20013:12395:12399:12501:12522:12481:12531:12391:12459:12454:12531:12479:12540:12395:23492:12426:12363:12363:12426:37202:12434:39154:12435:12391:12356:12427:29242:27096:12418:12356:12390:33391:12363:12387:12383:12290:20170:26085:12398:9675:12398:12362:23458:27096:12398:24179:22343:24180:40802:12399:12539:12539:12539:65302:65301:27507:12368:12425:12356:12363:12394:12392:19968:20154:32771:12360:12390:12356:12383:12425:12289:22909:12415:12398:29242:27096:12364:38563:12395:24231:12387:12390:26469:12390:12289:29983:12414:12428:12383:12414:12435:12414:12398:12393:9675:12385:12419:12435:12395:25265:12365:12388:12356:12390:12461:12473:12434:12375:12390:12365:12383:12290:12414:12354:12289:12371:12428:12418:25384:25334:12392:24605:12356:12289:24540:12376:12390:12420:12387:12383:12425:12289:29242:27096:12418:36234:20013:12363:12425:20803:27671:12395:12394:12387:12383:12385:9675:12413:12434:20986:12375:12390:35211:12379:12390:12367:12428:12383:12290:21448:51:26376:12398:35084:12497:12540:12486:12451:12540:12395:26469:12427:12392:35328:12358:12290:27005:12375:12415:12395:24453:12387:12390:12427:12424:12392:35328:12387:12383:12425:21916:12435:12391:12367:12428:12383:12415:12383:12356:12384:12290:20808:26085:12289:35199:24029:32209:36947:20844:22290:12398:28014:28010:32773:12364:51:20154:12411:12393:21015:12434:12394:12375:12390:12505:12531:12481:12395:23517:12390:12356:12383:12290:12431:12375:12364:19971:20998:12474:12508:12531:12395:22320:19979:36275:34955:23039:12391:12385:12435:12413:12434:35302:12426:12394:12364:12425:30446:12398:21069:12414:12391:34892:12367:12392:20013:12398:19968:20154:12364:65288:12354:12354:12373:12435:12424:12289:20309:12375:12390:12435:12376:12419:12289:12385:12435:12413:35302:12426:12394:12364:12425:65281:65289:12392:35328:12356:12289:12431:12375:12398:26041:12434:35211:12390:12356:12427:12290:12431:12375:12364:19971:20998:12363:12425:12385:12435:12413:12384:12375:12458:12452:12523:12434:12383:12425:12375:12394:12364:12425:21187:36215:12373:12379:12390:12363:12425:25531:12365:12394:12364:12425:35211:12379:12390:12358:12429:12358:12429:12375:12390:12356:12383:12290:65288:12354:12354:12373:12435:12424:12289:12362:21069:12289:12362:12363");
    }

    @Deprecated
    public static String getKurashikiMukaiyamaRoshutsuZuki2() {
        return IKSGDokataUtil.ango("12375:12356:12363:65311:22793:24907:12363:65311:12385:12435:12413:20986:12377:12394:12425:20182:12408:34892:12387:12390:12420:12428:12420:12290:65289:12393:12371:12391:12385:12435:12413:25531:12356:12390:12427:12435:12420:12290:12381:12358:35328:12431:12428:12394:12364:12425:12418:12431:12375:12364:12385:12435:12413:12434:25531:12356:12390:12356:12427:12392:12289:51:20154:12398:12394:12363:12398:19968:20154:12364:65288:22793:24907:12363:65311:12371:12398:31966:22303:26041:12364:12354:65374:65289:12381:12358:35328:12356:12394:12364:12425:12418:12431:12375:12398:12385:12435:12413:12378:12387:12392:35211:12390:12356:12427:12290:65288:12362:12387:12373:12435:12424:12289:12362:12387:12373:12435:12398:12385:12435:12413:33296:12417:12373:12379:12390:12367:12428:12420:12290:65289:12381:12358:35328:12356:12394:12364:12425:12418:23578:12418:12385:12435:12413:12434:25531:12356:12390:12356:12383:12425:23556:31934:12398:30636:38291:12364:36817:12389:12356:12390:12356:12383:12290:12354:12354:65374:65374:27671:25345:12385:12364:12360:12360:65342:65374:65374:12418:12358:20986:12381:12358:12376:12419:12354:65374:65374:12408:12435:12378:12426:12364:27671:25345:12385:12360:12360:65374:65374:65374:12354:12354:65374:65374:12356:12367:12358:12358:65374:65374:65374:12356:12367:12356:12367:12356:12367:65281:12381:12358:35328:12356:12394:12364:12425:51:20154:12398:28014:28010:32773:12398:21069:12391:12385:12435:12413:12363:12425:12289:24605:12356:20999:12426:23556:31934:12375:12390:12375:12414:12387:12383:12290:12402:12373:12375:12406:12426:12395:24195:23798:12398:30340:22580:12408:20986:12363:12369:12383:12290:26172:21069:12398:49:49:26178:12377:12366:12384:12290:26152:26085:12399:39154:12415:12377:12366:12383:12398:12391:23569:12375:30496:12383:12356:12398:12391:12289:24460:12429:12398:24109:12398:20013:22830:12395:24231:12387:12390:12356:12383:12425:30561:39764:12364:35186:12387:12390:12365:12383:12290:19979:21322:36523:12364:27671:25345:12385:12356:12356:12398:12391:30446:12434:38283:12369:12427:12392:20001:38563:12395:24231:12387:12383:12362:12387:12373:12435:12364:12431:12375:12398:12385:12435:12413:12420:12365:12435:12383:12414:12434:26381:12398:19978:12363:12425:12384:12364:12289:35302:12387:12390:12356:12427:12290:65288:12354:12354:65374:65374:27671:25345:12385:12356:12356:12394:12354:65374:65289:12375:12400:12425:12367:12289:12371:12398:12414:12414:12395:12375:12390:12362:12371:12358:12290:26144:30011:12364:22987:12414:12426:30011:38754:12391:12399:33509:12356:30007:12364:20013:24180:12398:30007:12398:12385:12435:12413:12434:33296:12417:12383:12426:12375:12390:12356:12427:20809:26223:12364:26144:12375:12384:12373:12428:12390:12356:12427:12290:12424:12369:12356:12395:33288:22894:12375:12390:12365:12383:12290:12431:12375:12364:12385:12435:12413:12434:12404:12367:12404:12367:12392:21205:12363:12377:12392:12289:21491:38563:12398:12362:12387:12373:12435:12364:12431:12375:12398:21322:12474:12508:12531:12398:12481:12515:12483:12463:12434:19979:12429:12375:12390:12474:12508:12531:12418:12378:12426:19979:12370:12424:12358:12392:12375:12390:12356:12427:12398:12391:12289:12431:12375:12364:33136:12434:25345:12385:19978:12370:12383:12425:12378:12427:12387:12392:35328:12358:12363:12435:12376:12391:12474:12508:12531:12364:36275:20803:12414:12391:38477:12426:12383:12290:36234:20013:35084:12398:27178:12363:12425:12385:12435:12413:12364:31361:12365:20986:12390:12356:12427:24863:12376:12384:12290:24038:12392:12394:12426:12398:12362:12387:12373:12435:12399:12431:12375:12398:21322:34966:12398:12459:12483:12479:12540:12398:21069:12508:12479:12531:12434:22806:12375:12390:12356:12427:12290:12371:12371:12395:26469:12427:12392:12365:12399:19979:30528:12399:36234:20013:12384:12369:12394:12398:12391:12289:12459:12483:12479:12540:12398:19979:12399:32032:32908:12384:12289:21322:12474:12508:12531:12434:36275:39318:12414:12391:19979:12429:12373:12428:12390:12459:12483:12479:12540:12434:38283:12369:12425:12428:12383:12425:12418:12358:20840:35064:12395:36817:12356:29366:24907:12384:12290:36763:12358:12376:12390:36234:20013:35084:12364:12354:12427:12364:12289:12381:12428:12418:21069:22402:12428:12434:25244:12365:21462:12425:12428:12390:12384:12425:12375:12394:12367:12369:12388:12398:19979:12395:12394:12387:12390:12356:12427:12290:12385:12435:12413:12364:12403:12435:12403:12435:12395:21187:36215:12375:12390:12356:12427:12290:21608:22258:12398:12362:12387:12373:12435:36948:12418:12431:12375:12398:26041:12434:12385:12425:12385:12425:12392:35211:12390:12356:12427:12290:24460:12429:12398:29242:12373:12435:12364:12431:12375:12398:24460:12429:12363:12425:25163:12434:22238:12375:12390:20083:39318:12395:35302:12387:12390:12365:12383:12290:23567:22768:12391:12289:12302:12405:12360:12354:12354:65374:65374:27671:25345:12385:12360:12360:12394:12354:65374:65374:12303:12392:35328:12358:12392:21491:38563:12392:24038:38563:12398:12362:12387:12373:12435:12364:12385:12435:12413:12420:12365:12435:12383:12414:12434:33296:12417:12383:12426:33229:12398:21608:36794:12434:22039:12417:22238:12377:12290:12302:12354:12354:65374:65374:12365:12418:12385:12360:12360:12424:12362:12362:65374:65374:12402:12419:12354:12354:65374:65374:12303:30011:38754:12434:35211:12394:12364:12425:12408:12435:12378:12426:12420:12365:12435:12383:12414:12434:33296:12417:12425:12428:12383:12425:12394:12435:12392:12418:12356:12360:12394:12356:12424:12290:19968:27573:12392:24555:24863:12364:35186:12387:12390:12365:12383:12290:12381:12398:26178:65288:12406:65374:65374:65374:65374:65289:12392:35328:12358:12502:12470:12540:12398:38899:12364:12375:12390:39208:20869:12398:29031:26126:12364:28857:12356:12383:12290:12431:12375:12398:21187:36215:12375:12383:12385:12435:12413:12364:20024:35211:12360:12395:12394:12427:12290:21491:38563:12398:12362:12387:12373:12435:12364:12394:12362:12418:12385:12435:12413:12434:33296:12417:12390:12356:12427:12375:24460:12429:12363:12425:12392:21069:12398:24109:12363:12425:12418:25163:12364:20280:12403:12390:12367:12427:12290:12302:12354:12354:12354:65374:27671:25345:12385:12360:12360:65374:65374:12303:24038:20596:12398:12362:12387:12373:12435:12364:12289:12302:12459:12483:12479:12540:12418:12474:12508:12531:12418:33073:12370:12289:12431:12375:12364:26381:12434:25345:12387:12390:12420:12427:12424:12289:12418:12387:12392:12418:12387:12392:35211:12390:36016:12360:12289:12381:12398:35084:12418:21462:12428:12289:30495:12387:35064:12391:24460:12429:12398:38263:12356:12377:12434:38283:12369:12390:12420:12427:12363:12425:12289:12381:12371:12414:12391:12385:12435:12413:36215:12387:12383:12414:12414:12356:12367:12363:65311:12303:12392:35328:12358:12290:12431:12375:12418:38706:20986:30294:12364:12416:12425:12416:12425:12392:12375:12390:12289:12302:12358:12435:12289:12371:12398:12414:12414:12289:26126:12427:12356:12414:12414:24460:12429:12398:26885:23376:12414:12391:19968:26086:21069:12395:34892:12387:12390:12363:12425:34892:12367:12431:65281:12303:12392:35328:12358:12392:12354:12365:12428:12383:24863:12376:12391:12302:12381:12358:12363:12354:65374:30342:12395:35211:12390:12418:12425:12356:12383:12356:12435:12363:12354:65374:12381:12435:12394:12425:26381:12399:25345:12387:12390:12420:12427:12363:12425:12356:12369:12424:12303:12392:12431:12375:12434:31435:12385:19978:12364:12425:12379:12383:12290:12362:23458:12364:12302:12362:12362:12362:65374:22793:24907:12420:12354:65374:12289:12414:12387:12401:12420:65281:12385:12435:12413:12383:12387:12392:12427:12435:12420:65281:12303:12392:35328:12358:22768:12364:32862:12371:12360:12383:12290:23578:12418:33288:22894:12375:31435:12385:19978:12364:12426:26126:12427:12356:29031:26126:12398:20013:12289:19968:26086:21069:12395:34892:12367:12392:12362:12387:12373:12435:12364:12354:12387:12385:12371:12387:12385:12363:12425:12431:12375:12398:12385:12435:12413:35302:12387:12390:12367:12427:12290:24460:12429:12398:38263:12356:12377:12414:12391:26469:12383:12425:26381:12434:25345:12387:12383:12362:12387:12373:12435:12364:38957:12398:19979:12395:26381:12434:32622:12365:12381:12371:12395:23517:12429:12392:35328:12358:12290:20309:20154:12418:12364:20170:24230:12399:35302:12387:12390:12365:12383:12426:12385:12435:12413:12434:33296:12417:12390:12365:12383:12290:12431:12375:12398:21475:12395:12418:12385:12435:12413:12364:20837:12428:12425:12428:12383:12414:12425:12435:12290:12371:12398:20877:12384:12392:24605:12356:12394:12364:12425:22823:22768:12391:39208:20869:12377:12409:12390:12395:32862:12371:12360:12427:12424:12358:12395:12424:12364:12387:12383:12290:12302:12354:12354:65374:65374:27671:25345:12385:12360:12360:65374:12418:12358:27713:12364:20986:12427:12454:65374:65374:12356:12367:65281:12356:12367:12358:12358:65374:65374:12354:12354:65374:65374:12356:12367:12358:65374:12303:30342:12364:35211:12390:12356:12427:21069:12391:33258:20998:12398:33145:12398:19978:12395:20309:20154:12363:12364:31934:28082:12434:12363:12369:12390:12367:12428:12383:12290:12431:12375:12418:33258:20998:12398:33145:12395:22823:37327:12395:27713:12434:12406:12385:12414:12369:12383:12364:26368:39640:12376:12419:65281:65281:20808:26085:65405:65392:65418:65439:65392:20843:38642:12395:20055:12387:12390:23665:38512:12399:31859:23376:12398:28201:27849:12395:34892:12387:12390:26469:12383:12364:12381:12398:26178:12398:20986:26469:20107:12384:12424:65381:12431:12375:12364:27850:12414:12387:12383:26053:39208:12399:32769:20154:20534:27005:37096:12398:24944:23433:20250:12364:34892:12431:12428:12390:12356:12390:39135:20107:12398:21069:12395:39080:21570:12395:20837:12387:12390:12356:12383:12425:33073:34915:22580:12391:29242:12373:12435:12398:22768:12364:32862:12371:12360:20986:12375:12383:12398:12391:28271:33337:12395:28024:12363:12387:12383:12414:12414:12391:33073:34915:22580:12398:26041:12434:35211:12390:12356:12383:12425:12460:12521:12460:12521:12392:12489:12450:12434:38283:12369:12390:20837:12387:12390:26469:12383:46:24180:12398:38915:12399:54:53:27507:12368:12425:12356:12363:63:21106:12426:12392:31435:27966:12394:20307:26684:12434:12375:12390:12356:12427:46:20307:12434:27927:12387:12390:12363:12425:12431:12375:12364:20837:12387:12390:12356:12427:12377:12368:27178:12395:20837:12387:12390:12365:12383:12364:12356:12365:12394:12426:35441:12375:25499:12369:12390:26469:12383:46:65288:28271:12364:29105:12356:12363:12425:27671:25345:12385:12364:12356:12356:12398:65374:65374:65374:33:41:12431:12375:12418:29105:12356:12394:12354:12392:35328:12356:12394:12364:12425:28271:33337:12398:32257:12395:33136:25499:12369:12390:12363:12425:33394:12293:35441:12434:12375:12390:12356:12383:12364:19979:30528:12398:35441:12395:12394:12387:12390:12363:12425:12431:12375:12364:36234:20013:35084:12434:32224:12417:12390:12356:12427:12392:35328:12387:12383:12425:12394:12380:12363:29242:12373:12435:12364:12431:12375:12418:36234:20013:35084:12434:32224:12417:12390:12356:12427:12387:12390:12356:12387:12383:12435:12391:12417:12378:12425:12375:12356:12394:12354:12392:35328:12387:12390:12420:12387:12383:46:32972:20013:12398:20837:22696:12364:35211:12360:12394:12356:12424:12358:12395:12354:12364:12387:12390:12363:12425:20307:12434:27927:12387:12390:12356:12383:12425:12431:12375:12398:27178:12395:26469:12390:12363:12425:65288:12354:12354:12373:12435:12398:32972:20013:12395:32186:40599:12394:20837:22696:12364:20837:12387:12390:12356:12427:12398:12362:41:35302:12387:12390:12418:12360:12360:12363:12398:12392:35328:12358:12394:12426:32972:20013:12420:22826:12418:12418:12395:35302:12387:12390:12365:12383:46:12394:12435:12384:12363:20182:12395:23458:12364:23621:12394:12356:12398:12391:12385:12435:12413:12364:36215:12387:12390:26469:12390:22256:12387:12383:12364:29242:12373:12435:12399:12381:12428:12434:35211:36867:12373:12394:12363:12387:12383:33:29242:12373:12435:12398:12385:12435:12413:12434:12385:12425:12387:12392:35211:12383:12425:12462:12531:65399:65438:65437:12395:36215:12387:12390:12356:12427:12391:12399:12394:12356:12363:12356:12365:12394:12426:29242:12373:12435:12364:12354:12354:12385:12419:12435:12398:12434:35302:12387:12383:12425:12431:12375:12398:12379:12364:12428:12364:36215:12387:12390:12375:12414:12387:12383:12382:46:35211:12390:12367:12428:12435:12363:12392:35328:12356:27927:12356:22580:12395:23517:36578:12435:12391:12363:12425:33258:20998:12391:12385:12435:12413:12434:12395:12366:12426:12375:12417:12379:12435:12378:12426:12434:25531:12365:22987:12417:12383:46:12362:12428:12398:12385:12435:12413:12364:31435:12387:12390:12356:12427:12398:12434:35211:12390:12363:12425:12375:12419:12406:12425:12379:12390:12367:12428:12435:12363:12392:35328:12358:12398:12391:29242:12373:12435:12398:21475:12395:20837:12428:12390:12420:12387:12383:46:12375:12400:12425:12367:12375:12390:12363:12425:12431:12375:12418:27671:25345:12385:12364:33391:12367:12394:12426:29242:12373:12435:12398:21475:12395:24605:12356:20999:12426:23556:31934:12375:12383:12364:29242:12373:12435:12399:39154:12415:36796:12435:12391:12375:12414:12387:12383:46:12431:12375:12418:12381:12428:12434:35211:12394:12364:12425:29242:12373:12435:12398:12385:12435:12413:12434:25531:12356:12390:12420:12427:12392:29242:12373:12435:12398:12385:12435:12413:12363:12425:21218:12356:12424:12367:27713:12364:20986:12390:12365:12383:46:19978:12364:12387:12390:12363:12425:36234:20013:12398:35441:12434:12375:12390:12363:12425:29242:12373:12435:12395:12431:12375:12398:37096:23627:12395:26469:12394:12356:12363:12392:12356:12387:12383:12425:12394:12435:12392:19968:20154:12391:30528:12390:12356:12427:12392:12398:20107:12391:26053:39208:12398:20154:12395:38972:12435:12391:12363:12425:37096:23627:12434:22823:12365:12356:37096:23627:12395:20195:12360:12390:12418:12425:12387:12390:37202:12434:39154:12415:20132:12431:12375:36234:20013:35084:19968:19969:12391:39135:20107:12434:12375:12383:46:39135:20107:12364:32066:12431:12426:25265:12365:21512:12387:12390:12363:12425:29242:12373:12435:12398:12369:12388:12395:20837:12428:12390:12420:12387:12383:12364:12424:12364:12426:22768:12398:22823:12365:12373:12395:22256:12426:35084:12434:21475:12395:20837:12428:12390:12420:12387:12383:26397:12289:23478:12434:26089:12417:12395:20986:12390:12289:29577:37326:24066:12398:28145:23665:20844:22290:12398:22675:22320:20844:22290:12398:19979:12398:39376:36554:22580:12391:19968:20241:12415:12434:12375:12390:12356:12383:12290:12394:12380:12363:26397:12363:12425:12385:12435:12413:12364:12403:12435:12403:12435:12395:21187:36215:12375:12390:12365:12383:12398:12391:24184:12356:26397:12399:12371:12398:20844:22290:22675:22320:39376:36554:22580:12395:12399:35504:12418:23621:12394:12363:12387:12383:12290:36554:12399:19968:21488:27490:12414:12387:12390:12356:12383:12364:12289:20013:12395:12399:20154:24433:12425:12375:12365:12418:12398:12399:12394:12363:12387:12383:12398:12391:36554:12398:36939:36578:24109:20596:12398:12489:12450:12434:38283:12369:12390:19971:20998:12474:12508:12531:12434:12378:12425:12375:36234:20013:35084:12398:21069:22402:12428:12434:25244:12365:21462:12426:12289:12521:12502:12458:12452:12523:12434:12385:12435:12413:12395:12383:12387:12407:12426:22615:12426:12388:12369:12390:12363:12425:12379:12435:12378:12426:12434:25531:12365:22987:12417:12383:12289:12375:12400:12425:12367:33394:12293:12394:24819:20687:12434:12375:12394:12364:12425:12385:12435:12413:12434:25531:12367:12290:12381:12358:12384:12539:12539:12539:20889:30495:12434:25774:12429:12358:12392:24605:12356:31435:12385:12289:12487:12472:12459:12513:12434:29992:24847:12375:12475:12523:12501:12479:12452:12510:12540:12434:12475:12483:12488:12290:20309:26522:12363:25774:24433:12434:34892:12387:12390:12356:12383:12425:12418:12398:12377:12372:12367:33288:22894:12375:12390:20170:12395:12418:12356:12365:12381:12358:12384:12290:12379:12435:12378:12426:12434:25531:12365:12394:12364:12425:20309:26522:12418:25774:24433:12377:12427:12290:12302:12354:12354:65374:65374:12383:12414:12425:12397:12360:65374:65374:12424:12289:12385:12435:12413:12364:27671:25345:12385:12360:12360:65374:65374:12354:12354:65374:65374:12303:12392:22768:12434:19978:12370:12390:12418:35504:12418:12356:12394:12356:12398:12391:25531:12365:12414:12367:12387:12390:12356:12383:12290:12375:12400:12425:12367:12375:12390:12356:12365:12381:12358:12395:12394:12387:12390:12365:12383:12398:12391:38542:27573:12395:24231:12387:12390:12363:12425:12385:12435:12413:12434:25531:12365:12414:12367:12387:12390:12356:12383:12425:12356:12365:12394:12426:12302:12354:12354:12373:12435:12424:12289:26397:12363:12425:12379:12435:12378:12426:25531:12356:12392:12435:12363:65311:27671:25345:12385:12360:12360:12363:65311:12303:12392:12362:12387:12373:12435:12398:22768:12364:12377:12427:12398:12391:24460:12429:12434:25391:12426:36820:12387:12383:12425:65302:65301:65374:65303:65296:12368:12425:12356:12398:12362:12387:12373:12435:12364:12376:12387:12392:31435:12387:12390:12431:12375:12398:12379:12435:12378:12426:12434:35211:12390:12356:12383:12289:12302:12354:12354:65374:65281:12385:12435:12413:12364:31435:12387:12390:12365:12383:12435:12391:12379:12435:12378:12426:12434:25531:12356:12392:12435:12420:65281:27671:25345:12385:12360:12360:12364:12394:65281:12303:12392:12431:12375:12364:35328:12358:12392:12362:12387:12373:12435:12364:12302:12431:12375:12364:35211:12383:12427:12369:12435:27671:25345:12385:12424:12358:27713:12434:12392:12400:12379:12360:65374:12420:12289:12418:12387:12392:36275:12434:20280:12400:12375:12390:12363:12425:22320:38754:12395:23517:36578:12435:12391:25531:12369:12420:65281:12303:12431:12375:12364:12302:12362:12387:12373:12435:12418:12385:12435:12413:35211:12379:12390:12367:12428:12435:12363:65311:12394:12354:12362:12387:12373:12435:12424:12289:12394:12435:12384:12387:12383:12425:12385:12435:12413:12375:12419:12406:12387:12390:12420:12429:12358:12363:65311:12303:12392:35328:12358:12392:12362:12387:12373:12435:12364:12431:12375:12398:27178:12395:26469:12390:12363:12425:30495:12387:40658:12394:28139:27700:28988:12369:12375:12383:40658:12378:12435:12384:12385:12435:12413:12434:31361:12365:20986:12375:12383:12398:12391:12431:12375:12399:12379:12435:12378:12426:12434:25531:12365:12394:12364:12425:12362:12387:12373:12435:12398:12385:12435:12413:12434:23610:20843:12375:12390:12420:12387:12383:12290:12362:12387:12373:12435:27671:25345:12385:12360:12360:12363:65311:12302:12354:12354:65374:65374:27671:25345:12385:12360:12360:12382:12289:30007:12395:12385:12435:12413:12375:12419:12406:12387:12390:12418:12425:12387:12390:27671:25345:12385:12360:12360:12364:12394:65281:12303:12392:35328:12358:12290:12375:12400:12425:12367:23610:20843:12434:12375:12390:12356:12383:12364:12362:12387:12373:12435:12364:12356:12365:12381:12358:12395:12394:12387:12383:12398:12363:12431:12375:12398:21475:12363:12425:12385:12435:12413:12434:25244:12371:12358:12392:12375:12390:12365:12383:12398:12391:12302:12362:12387:12373:12435:12289:21475:12398:20013:12395:27713:12434:12388:12366:36796:12435:12391:12367:12428:12420:12289:12431:12375:12364:12362:12387:12373:12435:12398:27713:12289:12398:12435:12384:12427:12369:12435:12303:12392:35328:12358:12394:12426:12362:12387:12373:12435:12364:12302:12354:12354:65374:65374:12356:12365:12381:12358:12420:12289:12385:12435:12413:12364:27671:25345:12385:12360:12360:12382:12356:12367:12358:65374:65374:65374:65374:65374:65374:65374:65374:65374:12356:12367:12387:65281:65281:12356:12367:12289:12356:12367:12358:12303:12392:22823:12365:12394:22768:12391:12431:12375:12398:21475:12395:31361:12365:20837:12428:12390:12393:12429:12387:12392:12375:12383:27713:12434:20986:12375:12383:12290:12381:12398:30636:38291:12395:12431:12375:12398:12385:12435:12413:12363:12425:12418:21218:12356:12424:12367:12375:12427:12364:33016:12398:26041:12414:12391:39131:12403:25955:12426:27671:25345:12385:12424:12363:12387:12383:12382:12290:12362:20114:12356:12395:12360:12360:27671:25345:12385:12395:12394:12387:12383:12364:12362:12387:12373:12435:12399:21021:12417:12390:12415:12383:12356:12391:12289:25918:24515:29366:24907:12395:12394:12387:12390:12375:12414:12387:12390:12356:12427:12290:12302:12362:12387:12373:12435:12424:12289:27671:25345:12385:12360:12363:12387:12383:12363:65311:12303:12392:32862:12367:12392:12358:12388:12429:12394:30446:12388:12365:12391:12302:12354:12354:65374:27671:25345:12385:12424:12363:12387:12383:12424:21448:12385:12435:12413:12364:31435:12387:12390:12365:12383:12424:12303:12392:35328:12356:12431:12375:12398:21475:12395:21448:31361:12365:20837:12428:12390:12365:12383:12290:12302:12362:12387:12373:12435:12289:12414:12384:12375:12419:12406:12387:12390:12411:12375:12356:12435:12363:65311:12385:12435:12413:33296:12417:12390:12411:12375:12356:12435:12363:65311:12303:12392:32862:12367:12392:12383:12414:12425:12435:12363:12425:12418:12387:12392:12420:12387:12390:21577:12428:12392:35328:12358:12290:20170:26085:12399:12371:12428:12363:12425:20181:20107:12364:12354:12427:12363:12425:21448:12302:20170:24230:12398:26376:26332:26085:12398:26397:12395:12371:12371:12395:26469:12383:12425:20170:24230:12399:12418:12387:12392:37329:29577:12418:12385:12435:12413:12418:12369:12388:12398:31348:12418:33296:12417:12390:12420:12427:12424:12303:12392:35328:12387:12390:21029:12428:12383:12364:26368:39640:12398:12379:12435:12378:12426:12398:25531:12365:12354:12356:12364:12391:12365:12383:12380:12290:23713:23665:12398:35199:24029:20844:22290:12398:12505:12531:12481:12395:12289:24231:12387:12390:12356:12383:12425:12393:12371:12363:12398:12362:12387:12373:12435:12364:12289:12431:12375:12398:27178:12395:24231:12426:12385:12435:12413:12434:35302:12387:12390:26469:12383:12290:12377:12368:27178:12395:12399:28014:28010:32773:12364:24231:12387:12390:12356:12427:12290:12431:12375:12399:12362:12387:12373:12435:12364:12373:12431:12426:25746:12367:12387:12390:26469:12383:12398:12391:12385:12435:12413:12364:12403:12435:12403:12435:12395:12394:12426:24605:12356:20999:12387:12390:19971:20998:12434:12378:12425:12375:35084:12418:12402:12365:12396:12356:12383:65281:12362:12387:12373:12435:12364:12385:12435:12413:12434:35302:12387:12383:12426:12289:12375:12419:12406:12426:12414:12367:12427:12398:12391:12289:24605:12431:12378:22768:12364:12391:12427:65281:12300:12383:12414:12425:12397:12540:12540:65281:12385:12435:12413:12364:27671:25345:12385:12360:12360:12540:12540:65281:12301:27178:12398:28014:28010:32773:12395:35211:12379:20184:12369:12427:12424:12358:12395:12289:12431:12374:12392:22768:12434:20986:12375:12394:12364:12425:12289:12424:12364:12426:12414:12367:12426:12300:12385:12435:12413:12364:12289:12383:12414:12425:12397:12359:12540:12540:12540:12540:12540:65281:12301:12375:12400:12425:12367:12375:12390:12362:12387:12373:12435:12364:12369:12388:12398:31348:12434:33296:12417:12399:12376:12417:12383:65281:12418:12358:12377:12368:12289:12356:12365:12381:12358:12384:65281:28014:28010:32773:12364:35211:12390:12356:12427:21069:12391:24605:12356:20999:12426:12289:12385:12435:12413:12363:12425:27713:12434:23556:31934:12375:12383:12364:12289:12383:12414:12425:12394:12363:12387:12383:12290:26152:26085:12363:12425:12398:32154:12365:12391:12289:12414:12384:38957:12364:30171:12356:65281:26172:12398:39135:20107:12399:26222:36890:12395:39135:12409:12383:12290:12381:12398:24460:12522:12509:12499:12479:12531:12434:49:26412:12392:12454:12467:12531:12398:38982:31890:12392:39080:37034:34220:12289:12360:12418:12358:22823:22793:12384:12290:12381:12428:12391:12418:39135:27442:12392:24615:27442:12384:12369:12399:20154:19968:20493:24375:12356:12424:12290:12497:12477:12467:12531:12391:12452:12531:12479:12540:12493:12483:12488:12434:12375:12390:12415:12383:12425:12289:12385:12435:12413:12364:12358:12378:12367:12539:12539:12539:35084:12398:21069:34955:12364:12376:12387:12392:12426:12392:12396:12428:12390:12356:12427:12290:21491:25163:12391:12497:12477:12467:12531:12434:12375:12394:12364:12425:12289:24038:25163:12391:12385:12435:12413:12434:12371:12377:12427:12290:12302:12354:12354:12354:65374:65374:65374:65281:27671:25345:12385:12360:12360:12394:12354:65374:65374:65281:12385:12435:12413:12364:27671:25345:12385:12360:12360:65281:12303:38754:20498:12367:12373:12356:12398:12391:36234:20013:35084:12434:33073:12366:25448:12390:12390:12289:24038:25163:12395:12521:12502:12458:12452:12523:12434:12388:12369:20096:38957:12434:12371:12397:12367:12426:12414:12431:12377:12539:12539:12302:12354:12354:65374:65374:65281:12383:12414:12425:12397:12360:65374:65374:12424:12289:12385:12435:12413:12364:12383:12414:12425:12397:65374:65374:12360:65374:65374:65281:12289:37329:29577:12364:12365:12421:12387:12392:12354:12364:12387:12390:12367:12427:12398:12364:35299:12427:12290:12375:12363:12375:38957:30171:12364:12402:12393:12356:12398:12391:12354:12414:12426:28961:29702:12434:12375:12394:12356:31243:24230:12395:12385:12435:12413:12434:25531:12367:12289:12371:12398:12414:12414:12384:12392:12377:12368:12395:27671:12364:34892:12387:12390:12375:12414:12356:12381:12358:12395:12394:12427:12289:12394:12435:12384:12363:21247:20307:28961:12356:12415:12383:12356:12384:12290:23569:12375:12384:12369:38957:30171:12364:12377:12427:12398:12434:25105:24930:12375:22823:12365:12394:39080:21570:12395:20837:12387:12390:20307:12434:20241:12417:12424:12358:12392:24605:12387:12383:12398:12391:12289:36817:12367:12398:37549:28271:12408:20986:12363:12369:12427:20107:12395:12375:12383:12289:12431:12374:12392:12289:36196:12398:36234:20013:35084:12395:32224:12417:30452:12375:12362:39080:21570:12475:12483:12488:12434:12418:12385:38634:39364:12434:23653:12356:12390:12363:12425:23478:12363:12425:65299:20998:12368:12425:12356:12398:12354:12414:12426:23458:12364:26469:12394:12356:37549:28271:12395:20986:12363:12369:12383:12289:20837:12426:21475:12391:51:52:48:20870:12434:25173:12387:12390:12363:12425:33073:34915:22580:12398:31840:12395:12422:12387:12367:12426:12392:33073:12356:12391:34892:12367:12392:12431:12375:12398:24460:12363:12425:20837:12387:12390:26469:12383:29242:12373:12435:12364:20170:12289:12362:37329:12434:25173:12387:12390:12356:12383:12398:12391:35084:23039:12434:35211:12379:12383:12425:12393:12435:12394:21453:24540:12434:31034:12377:12363:12394:12392:24605:12356:29242:12373:12435:12364:20837:12387:12390:26469:12427:12414:12391:12474:12508:12531:12434:33073:12364:12378:12395:23621:12383:12290:29242:12373:12435:12364:20837:12387:12390:26469:12383:12398:12391:27178:12395:31840:12434:32622:12356:12390:12521:12531:12491:12531:12464:12471:12515:12484:12434:33073:12356:12384:12425:29242:12373:12435:12364:12431:12375:12398:32972:20013:12398:20837:22696:12434:12481:12521:12483:12392:35211:12383:12289:12381:12398:24460:29242:12373:12435:12364:35211:12390:12383:12398:12391:12474:12508:12531:12434:33073:12356:12384:12425:12414:12384:29242:12373:12435:12364:12431:12375:12398:26041:12434:35211:12390:12356:12383:12289:12394:12435:12384:12363:12376:12387:12392:35211:12425:12428:12383:12425:27671:25345:12385:12364:33391:12356:12290:27927:12356:22580:12395:20837:12387:12390:12363:12425:20307:12434:27927:12387:12390:12356:12383:12425:29242:12373:12435:12364:20837:12387:12390:26469:12383:12290:12394:12380:12363:12431:12375:12398:38563:12395:24231:12387:12383:12290:12431:12374:12392:29242:12373:12435:12395:35211:12360:12427:12424:12358:12395:12385:12435:12413:12434:12372:12375:12372:12375:27927:12387:12390:12356:12383:12425:27671:25345:12385:12364:33391:12367:12394:12387:12390:23436:20840:12395:21187:36215:12375:12390:12375:12414:12387:12383:12290:12431:12375:12399:29242:12373:12435:12364:20307:12434:27927:12387:12390:23621:12427:12377:12368:27178:12391:12289:12385:12435:12413:12434:21187:36215:12373:12379:12383:12414:12414:31435:12385:19978:12364:12387:12390:12471:12515:12527:12540:12434:12363:12369:12383:12364:12431:12374:12392:29242:12373:12435:12395:35211:12360:12427:12424:12358:12395:12385:12435:12413:12434:27927:12356:12394:12364:12425:12302:12354:12354:65374:65374:27671:25345:12385:12364:12360:12360:12394:12354:65374:65374:12289:12385:12435:12413:12364:31435:12387:12390:12375:12418:12358:12383:12431:12289:65281:65281:12303:12392:29420:12426:35328:12398:12424:12358:12395:34892:12387:12390:12431:12374:12392:20108:19977:22238:12385:12435:12413:12434:25531:12356:12383:12289:12431:12375:12392:29242:12373:12435:12375:12363:12356:12394:12356:12398:12391:29242:12373:12435:12395:12302:29242:12373:12435:12289:12385:12435:12413:12364:31435:12387:12390:12375:12418:12358:12383:12431:12289:29242:12373:12435:12418:12385:12435:12413:31435:12388:26178:12364:12354:12429:12358:12364:12289:12379:12435:12378:12426:25531:12363:12435:12392:12362:12373:12414:12425:12435:12398:12362:65374:65374:12303:12392:35328:12387:12390:12363:12425:29242:12373:12435:12398:25163:12434:63:12435:12391:12363:12425:12431:12375:12398:12385:12435:12413:12434:35302:12425:12379:12383:12364:12302:12354:12354:12385:12419:12435:12424:12289:12379:12435:12378:12426:25531:12367:12435:12394:12425:12431:12375:12364:12420:12387:12383:12425:12435:12363:65374:65374:12303:12392:35328:12387:12390:12363:12425:12431:12375:12398:12385:12435:12413:12434:12356:12365:12394:12426:23610:20843:12375:12390:12367:12428:12383:12364:20837:12428:27503:12434:12399:12378:12375:12390:12356:12390:12289:12383:12414:12425:12394:12367:27671:25345:12385:12364:12360:12360:12289:30058:21488:12363:12425:35211:12360:12394:12356:12398:12391:29242:12373:12435:12398:12385:12435:12413:12418:23610:20843:12375:12390:12420:12387:12383:12289:65302:65305:12395:12394:12426:39080:21570:22580:12395:23517:12381:12409:12387:12390:12385:12435:12413:12398:21560:12356:12354:12356:12399:12383:12414:12425:12435:12289:12302:29242:12373:12435:12289:27671:25345:12385:12364:12360:12360:12382:12289:12385:12435:12413:12364:12365:12418:12385:12360:12360:12382:12289:12418:12358:34892:12387:12390:12375:12414:12358:12289:12354:12354:12383:12414:12425:12397:12360:12303:12375:12400:12425:12367:12375:12383:12425:29242:12373:12435:12398:12385:12435:12413:12364:33192:12428:12383:12392:24605:12387:12383:30636:38291:12431:12375:12398:21475:12398:20013:12395:29242:12373:12435:12364:23556:31934:12375:12383:12290:12392:21516:26178:12395:12431:12375:12418:29242:12373:12435:12398:21475:12398:20013:12395:12539:12539:65281:65281:12371:12435:12394:12371:12392:12387:12390:12354:12427:12435:12384:12394:12290:21448:12371:12398:26178:38291:12395:12371:12424:12358:12392:24605:12387:12383:12290:23713:23665:39365:21069:12398:23713:23665:20250:39208:12499:12523:12398:22320:19979:20415:25152:12395:34892:12387:12390:35211:12383:12289:12431:12375:12398:22909:12415:12399:12362:12387:12373:12435:12394:12398:12391:12289:12375:12400:12425:12367:22806:12391:35211:12390:23621:12383:12425:12362:12387:12373:12435:12364:12399:12356:12387:12390:34892:12387:12383:12398:12391:12431:12375:12418:20837:12387:12383:12425:19968:30058:22885:12391:23567:20415:12434:12375:12390:23621:12427:35211:12383:12356:12394:12435:12391:12289:27178:12395:12356:12387:12383:12425:23567:20415:12418:12379:12378:12395:12385:12435:12413:12434:12384:12375:12383:12414:12414:12379:12435:12378:12426:12434:12363:12356:12390:12356:12427:12435:12391:12289:12362:12387:12373:12435:12395:12360:12360:12385:12435:12413:12375:12390:12427:12398:12358:12379:12435:12378:12426:12363:12363:12435:12363:65311:35328:12387:12383:12425:12431:12375:12398:12385:12435:12413:12395:25163:12434:20986:12375:12383:12435:12391:12431:12375:12418:12362:12387:12373:12435:12398:12385:12435:12413:12395:12366:12387:12383:12425:12356:12365:12394:12426:25265:12365:12388:12356:12390:26469:12383:12290:23567:20415:22120:12398:21069:12391:12362:12387:12373:12435:12392:25265:12365:21512:12356:12461:12473:12434:12375:12390:12385:12435:12413:12434:12371:12377:12426:12354:12387:12390:12356:12427:12398:12418:12394:12435:12384:12363:12425:12289:22885:12398:20491:23460:12395:20837:12387:12383:12364:20491:23460:12398:12489:12450:12399:38283:12369:12383:12414:12414:12391:12362:12387:12373:12435:12392:12431:12375:12399:12474:12508:12531:12434:12378:12425:12375:12383:12414:12414:12385:12435:12413:12434:21512:12431:12379:12461:12473:12434:12375:12390:12420:12427:12392:20808:36208:12426:12391:33145:12364:12378:12427:12378:12427:12395:12394:12427:12368:12425:12356:12384:12290:12362:12387:12373:12435:12364:12431:12375:12398:12385:12435:12413:12395:12416:12375:12419:12406:12426:12388:12356:12390:37329:29577:12414:12391:12394:12417:12390:12356:12427:12290:12489:12450:12364:38283:12356:12390:12356:12427:12398:12391:12431:12375:12425:12398:27096:23376:12364:23567:20415:22120:12363:12425:20024:35211:12360:12384:12364:27671:12395:12375:12394:12356:12391:12420:12426:12414:12367:12427:12290:12362:12387:12373:12435:12398:12369:12388:12398:31348:12434:12394:12417:12390:12385:12435:12413:12434:25276:12375:36796:12435:12384:12425:27671:25345:12385:12356:12356:12290:12362:12387:12373:12435:12418:12424:12364:12426:12414:12367:12387:12390:22768:12434:20986:12375:12390:12356:12427:12290:12356:12388:12398:12414:12395:12363:53:20154:12418:12431:12375:12425:12434:35211:12390:12356:12427:12398:12391:33288:22894:12375:23556:31934:12375:12383:12356:12388:12418:31435:12385:23492:12427:28145:23665:20844:22290:12398:39376:36554:22580:12391:30333:33394:12398:12510:12540:12463:8545:12395:12398:12387:12390:12356:12427:65302:65296:27507:12368:12425:12356:12398:12362:12376:12373:12435:12364:12289:12431:12375:12398:36554:12398:21069:12395:12356:12388:12418:20572:36554:12375:12390:12289:36939:36578:24109:12363:12425:38477:12426:12390:12363:12425:12471:12540:12488:12434:20498:12375:12390:12289:26032:32862:12434:35501:12435:12391:12356:12427:12435:12384:12364:12289:12356:12388:12418:29255:25163:12399:32929:12398:38291:12391:33258:20998:12391:12379:12435:12378:12426:12434:25531:12367:12424:12358:12394:12375:12368:12373:12391:12385:12435:12413:12434:25545:12435:12391:12356:12427:12435:12384:12290:65288:31505:65289:36523:38263:12399:65297:65302:65296:12475:12531:12481:12368:12425:12356:12289:20307:37325:12399:24656:12425:12367:65304:65296:12461:12525:12368:12425:12356:12384:12429:12358:12392:24605:12358:12364:12289:38957:12399:12431:12375:12392:19968:32210:12391:20024:31167:12370:12394:12435:12384:12290:20170:26085:12399:12354:12414:12426:12431:12375:12398:21069:12395:26469:12390:12363:12425:32929:12398:38291:12434:25545:12416:12435:12391:12289:20182:12395:35504:12418:35211:12360:12394:12363:12387:12383:12398:12391:12289:24605:12356:20999:12387:12390:36234:20013:35084:12392:22320:19979:36275:34955:12395:12394:12387:12390:12381:12398:12362:12387:12373:12435:12398:27178:12395:34892:12387:12390:12363:12425:12289:12362:12387:12373:12435:12395:12302:12362:12387:12373:12435:12289:12356:12388:12418:12371:12371:12391:26032:32862:35501:12435:12391:12435:12363:12354:65374:12381:12428:12392:12418:12408:12435:12378:12426:12391:12418:25531:12356:12390:12427:12435:12363:65311:65311:12385:12435:12413:12400:12387:12363:12426:25545:12435:12391:21187:36215:12377:12427:12435:12363:12354:65374:12303:12392:24605:12356:20999:12426:35328:12387:12390:12420:12387:12383:12424:12290:12381:12375:12383:12425:12289:12474:12508:12531:12363:12425:12431:12375:12364:35328:12358:12392:12385:12435:12413:20986:12375:12390:35211:12379:12390:12363:12425:12289:8810:12431:12375:12398:12408:12435:12378:12426:35211:12390:12367:12428:12435:12363:12289:12431:12375:12418:36234:20013:35084:12394:12435:12420:12289:35211:12390:12367:12428:12424:65281:65281:12431:12356:12398:12408:12435:12378:12426:35211:12390:12420:65281:65281:8811:12392:35328:12358:12394:12426:36947:36335:12363:12425:12399:35211:12360:12394:12356:25152:12384:12364:12289:30495:12387:35064:12395:12394:12387:12390:12375:12414:12356:12385:12435:12413:12434:25531:12356:12390:35211:12379:12390:12367:12428:12383:12290:12431:12375:12364:12362:12387:12373:12435:12398:21475:12395:12385:12435:12413:23451:12364:12358:12392:12289:12362:12387:12373:12435:12399:12431:12356:12398:12385:12435:12413:12378:12426:12378:12426:12392:12375:12419:12406:12387:12390:12367:12428:12383:12289:24605:12356:20999:12426:12362:12387:12373:12435:12398:21475:12395:23556:31934:12375:12390:12420:12387:12383:12425:12289:12362:12387:12373:12435:12418:33258:20998:12391:12408:12435:12378:12426:25531:12356:12390:33145:12398:19978:12395:30333:23376:12434:12406:12385:12414:12369:12383:12424:12290:26368:39640:12384:12387:12383:12290");
    }

    public static String getKurashikiMukaiyamaRoshutsuZukiAll() {
        return IKSGDokataUtil.getDokata("kurashikimukaiyamaroshutsuzuki");
    }

    private static String ango(String st) {
        return IKSGStringUtil.getIntsToString(IKSGMath.getStringIntArry(st));
    }

    public static enum Dokatas implements IStringSerializable
    {
        KUSOMAMIRE(IKSGDokataUtil::getKusomamire),
        YATTAZE(IKSGDokataUtil::getYattaze),
        YARITAI(IKSGDokataUtil::getYaritai),
        SENZURI(IKSGDokataUtil::getSenzuri),
        KUSOKUSOKUSO(IKSGDokataUtil::getKusoKusoKuso),
        KUSOMAMIREDE(IKSGDokataUtil::getKusomamirede),
        KUSOZUKIOYAJIJISAMABOSHU(IKSGDokataUtil::getKusozukiOyajiJisamaBoshu),
        KUSOMAMIREDE2(IKSGDokataUtil::getKusomamirede2),
        HAYAKUYARIMAKURITAIYO(IKSGDokataUtil::getHayakuYariMakuriTaiyo),
        HAYAKUKUSOMAMIRENI(IKSGDokataUtil::getHayakuKusoMamireni),
        KUSOMAMIRE2(IKSGDokataUtil::getKusomamire2),
        KUSOMAMIRE3(IKSGDokataUtil::getKusomamire3),
        KINDANSYOUJOGA(IKSGDokataUtil::getKindanSyouJoga),
        KUSOOYAJI(IKSGDokataUtil::getKusoOyaji),
        YAROUZE(IKSGDokataUtil::getYarouze),
        YAGAIDE(IKSGDokataUtil::getYagaiDe),
        KUSOMAMIRE4(IKSGDokataUtil::getKusomamire4),
        YARITEXE(IKSGDokataUtil::getYaritexe),
        KUSOMAMIREDE3(IKSGDokataUtil::getKusomamirede3),
        KUSOMAMIRE5(IKSGDokataUtil::getKusomamire5),
        KUSO(IKSGDokataUtil::getKuso),
        KUSODAISUKI(IKSGDokataUtil::getKusoDaisuki),
        YAMANONAKADE(IKSGDokataUtil::getYamaNoNakaDe),
        YAMANONAKADE2(IKSGDokataUtil::getYamaNoNakaDe2),
        YAMANONAKADE3(IKSGDokataUtil::getYamaNoNakaDe3),
        SIBATTE(IKSGDokataUtil::getSibatte),
        HONKIDE(IKSGDokataUtil::getHonkide),
        HENTAIDAISUKI(IKSGDokataUtil::getHentaiDaisuki),
        FUROSHANOOSSAN(IKSGDokataUtil::getFuroShaNoOssan),
        YAGAIDE2(IKSGDokataUtil::getYagaiDe2),
        MAKKURO(IKSGDokataUtil::getMakkuro),
        YARIMAKURI(IKSGDokataUtil::getYarimakuri),
        KUSHIZASHI(IKSGDokataUtil::getKushizashi),
        ROSHUTSUSHITAZE(IKSGDokataUtil::getRoshutsuShitaZe),
        YAROUZE2(IKSGDokataUtil::getYarouze2),
        ISSYONI(IKSGDokataUtil::getIssyoni),
        OKAYAMADE(IKSGDokataUtil::getOkayamade),
        KURASHIKIMUKAIYAMAROSHUTSUZUKI(IKSGDokataUtil::getKurashikiMukaiyamaRoshutsuZuki);

        private final Supplier<String> str;

        private Dokatas(Supplier<String> st) {
            this.str = st;
        }

        public String func_176610_l() {
            return this.str.get();
        }
    }
}

