/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.otyacraftengine.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import red.felnull.otyacraftengine.OtyacraftEngine;
import red.felnull.otyacraftengine.libs.dev.felnull.fnjl.util.FNDataUtil;

public class IKSGFileLoadUtil {
    @Deprecated
    public static void createFolder(Path path) {
        if (path == null) {
            return;
        }
        path.toFile().mkdirs();
    }

    @Deprecated
    public static byte[] fileBytesReader(Path path) {
        try {
            return Files.readAllBytes(path);
        }
        catch (IOException e) {
            OtyacraftEngine.LOGGER.error("Failed to Read the File : " + e.getLocalizedMessage());
            return null;
        }
    }

    @Deprecated
    public static boolean deleteFile(Path path) {
        return IKSGFileLoadUtil.deleteFile(path.toFile());
    }

    @Deprecated
    public static boolean deleteFile(File file) {
        return file.delete();
    }

    public static void fileNBTWriter(CompoundNBT nbt, Path path) {
        IKSGFileLoadUtil.createFolder(path.getParent());
        try {
            FileOutputStream stream = new FileOutputStream(path.toFile());
            CompressedStreamTools.func_74799_a((CompoundNBT)nbt, (OutputStream)stream);
        }
        catch (IOException e) {
            OtyacraftEngine.LOGGER.error("Failed to Write the NBT File : " + e.getLocalizedMessage());
        }
    }

    public static CompoundNBT fileNBTReader(Path path) {
        if (!path.toFile().exists()) {
            return new CompoundNBT();
        }
        try {
            FileInputStream stream = new FileInputStream(path.toFile());
            return CompressedStreamTools.func_74796_a((InputStream)stream);
        }
        catch (IOException e) {
            OtyacraftEngine.LOGGER.error("Failed to Read the NBT File : " + e.getLocalizedMessage());
            return null;
        }
    }

    public static void txtWriter(Map<String, String> map, Path path) {
        IKSGFileLoadUtil.createFolder(path.getParent());
        try {
            FileWriter fw = new FileWriter(path.toString(), false);
            PrintWriter pw = new PrintWriter(new BufferedWriter(fw));
            map.forEach((key, value) -> pw.println(key + ":" + value));
            pw.close();
        }
        catch (IOException e) {
            OtyacraftEngine.LOGGER.error("Failed to Write the Txt File : " + e.getLocalizedMessage());
        }
    }

    public static void txtWriter(String text, Path path) {
        IKSGFileLoadUtil.createFolder(path.getParent());
        try {
            FileWriter fw = new FileWriter(path.toString(), false);
            PrintWriter pw = new PrintWriter(new BufferedWriter(fw));
            pw.println(text);
            pw.close();
        }
        catch (IOException e) {
            OtyacraftEngine.LOGGER.error("Failed to Write the Txt File : " + e.getLocalizedMessage());
        }
    }

    public static void txtReader(Map<String, String> map, Path path) {
        map.clear();
        try {
            String st;
            FileReader re = new FileReader(path.toString());
            BufferedReader bre = new BufferedReader(re);
            while ((st = bre.readLine()) != null) {
                try {
                    String[] fruit = st.split(":", 0);
                    map.put(fruit[0], fruit[1]);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            OtyacraftEngine.LOGGER.error("Failed to Read the Txt File : " + e.getLocalizedMessage());
        }
    }

    @Deprecated
    public static byte[] getCheckSumByte(File file) throws IOException, NoSuchAlgorithmException {
        int numRead;
        FileInputStream fis = new FileInputStream(file);
        byte[] buffer = new byte[1024];
        MessageDigest complete = MessageDigest.getInstance("MD5");
        do {
            if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
            complete.update(buffer, 0, numRead);
        } while (numRead != -1);
        ((InputStream)fis).close();
        return complete.digest();
    }

    public static int getCheckSum(File file) throws IOException, NoSuchAlgorithmException {
        return ByteBuffer.wrap(IKSGFileLoadUtil.getCheckSumByte(file)).getInt();
    }

    @Deprecated
    public static void fileBytesWriter(byte[] bytedatas, Path path) {
        IKSGFileLoadUtil.createFolder(path.getParent());
        try {
            Files.write(path, bytedatas, new OpenOption[0]);
        }
        catch (IOException e) {
            OtyacraftEngine.LOGGER.error("Failed to Write the File : " + e.getLocalizedMessage());
        }
    }

    @Deprecated
    public static void fileCopyWriter(Path src, Path target, CopyOption ... options) throws IOException {
        Files.copy(src, target, options);
    }

    @Deprecated
    public static void fileURLWriter(URL url, Path target, CopyOption ... options) throws IOException {
        IKSGFileLoadUtil.fileInputStreamWriter(url.openStream(), target, options);
    }

    @Deprecated
    public static void fileInputStreamWriter(InputStream stream, Path target, CopyOption ... options) throws IOException {
        Files.copy(new BufferedInputStream(stream), target, options);
    }

    @Deprecated
    public static void fileBytesWriterProgress(byte[] data, Path target, IProgressListener listener) throws IOException {
        IKSGFileLoadUtil.fileInputStreamWriterProgress(new ByteArrayInputStream(data), target, data.length, listener);
    }

    @Deprecated
    public static void fileCopyWriterProgress(Path src, Path target, IProgressListener listener) throws IOException {
        FNDataUtil.fileCopyToProgress(src.toFile(), target.toFile(), n -> listener.progressListener((float)n.getProgress()));
    }

    @Deprecated
    public static void fileURLWriterProgress(URL url, Path target, IProgressListener listener) throws IOException {
        FNDataUtil.fileDownloadToProgress(url, target.toFile(), n -> listener.progressListener((float)n.getProgress()));
    }

    @Deprecated
    public static void fileInputStreamWriterProgress(InputStream streama, Path target, long size, IProgressListener listener) throws IOException {
        FNDataUtil.fileWriteToProgress(streama, size, target.toFile(), writeProgressListener -> listener.progressListener((float)writeProgressListener.getProgress()));
    }

    @Deprecated
    public static interface IProgressListener {
        public void progressListener(float var1);
    }
}

