/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.otyacraftengine.util;

import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import red.felnull.otyacraftengine.api.registries.OERegistries;
import red.felnull.otyacraftengine.util.IKSGColorUtil;
import red.felnull.otyacraftengine.util.IKSGMath;

public class IKSGModUtil {
    public static String getModVersion(String modid) {
        try {
            return ((ArtifactVersion)ModList.get().getModContainerById(modid).map(modContainer -> modContainer.getModInfo().getVersion()).orElse(null)).toString();
        }
        catch (Exception e) {
            return "Error!!";
        }
    }

    public static String getModName(String modid) {
        try {
            return ModList.get().getModContainerById(modid).map(modContainer -> modContainer.getModInfo().getDisplayName()).orElse(StringUtils.capitalize((String)modid));
        }
        catch (Exception e) {
            return "Error!!";
        }
    }

    public static TextFormatting getModColor(String modid) {
        if (OERegistries.MOD_COLOR.containsKey(modid)) {
            return IKSGColorUtil.convertTextFormattingFromColorCode(OERegistries.MOD_COLOR.get(modid));
        }
        Random r = new Random(IKSGMath.convertStringToInteger(modid));
        return IKSGColorUtil.convertTextFormattingFromColorCode(r.nextInt(0xFFFFFF));
    }

    public static String getModID(ItemStack stack) {
        return stack.func_77973_b().getCreatorModId(stack);
    }
}

