/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.otyacraftengine.util;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.StreamSupport;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.util.ResourceLocation;
import red.felnull.otyacraftengine.util.IKSGServerUtil;
import red.felnull.otyacraftengine.util.IKSGURLUtil;

public class IKSGPlayerUtil {
    public static final String FAKE_UUID = "5EBB1E27-142C-4108-9472-6B65DEF8FF21";
    public static final String FAKE_PLAYERNAME = "UnknowOfUnknowInUnknowFromUnknow";
    protected static final Map<String, GameProfile> PLAYERGAMEPROFILES = new HashMap<String, GameProfile>();
    protected static final Map<String, String> PLAYERSKINURLS = new HashMap<String, String>();
    protected static final Map<String, String> PLAYERNAMES = new HashMap<String, String>();
    private static final Gson gson = new Gson();

    public static String getUserName(PlayerEntity pl) {
        return pl.func_146103_bH().getName();
    }

    public static String getUUID(PlayerEntity pl) {
        return PlayerEntity.func_146094_a((GameProfile)pl.func_146103_bH()).toString();
    }

    public static String getPlayerName(String uuid) {
        if (PLAYERNAMES.containsKey(uuid)) {
            return PLAYERNAMES.get(uuid);
        }
        PLAYERNAMES.put(uuid, "");
        NameLoader NL = new NameLoader(uuid);
        NL.start();
        return "";
    }

    public static String getPlayerSkinTextureURL(String uuid) {
        if (PLAYERSKINURLS.containsKey(uuid)) {
            return PLAYERSKINURLS.get(uuid);
        }
        PLAYERSKINURLS.put(uuid, "");
        SkinURLLoader SUL = new SkinURLLoader(uuid);
        SUL.start();
        return "";
    }

    public static GameProfile getPlayerProfileByUUID(String uuid) {
        if (PLAYERGAMEPROFILES.containsKey(uuid)) {
            return PLAYERGAMEPROFILES.get(uuid);
        }
        GameProfile gp = new GameProfile(UUID.fromString(uuid), null);
        PLAYERGAMEPROFILES.put(uuid, gp);
        GameProfileLoader GPL = new GameProfileLoader(uuid);
        GPL.start();
        return gp;
    }

    public static GameProfile getPlayerProfile(String name) {
        if (PLAYERGAMEPROFILES.containsKey(name)) {
            return PLAYERGAMEPROFILES.get(name);
        }
        GameProfile gp = new GameProfile(UUID.fromString(FAKE_UUID), name);
        PLAYERGAMEPROFILES.put(name, gp);
        GameProfileLoader GPL = new GameProfileLoader(name);
        GPL.start();
        return gp;
    }

    public static ServerPlayerEntity getPlayerByUUID(String uuid) {
        return IKSGServerUtil.getMinecraftServer().func_184103_al().func_177451_a(UUID.fromString(uuid));
    }

    public static void grantAdvancement(ResourceLocation rl, ServerPlayerEntity spl) {
        Advancement advancement = spl.func_184102_h().func_191949_aK().func_192778_a(rl);
        AdvancementProgress advancementprogress = spl.func_192039_O().func_192747_a(advancement);
        if (advancementprogress.func_192105_a()) {
            return;
        }
        for (String s : advancementprogress.func_192107_d()) {
            spl.func_192039_O().func_192750_a(advancement, s);
        }
    }

    private static class SkinURLLoader
    extends Thread {
        private String uuid;

        public SkinURLLoader(String uuid) {
            this.uuid = uuid;
        }

        @Override
        public void run() {
            try {
                String f1 = IKSGURLUtil.getURLResponse("https://sessionserver.mojang.com/session/minecraft/profile/" + this.uuid);
                JsonObject f1jo = (JsonObject)gson.fromJson(f1, JsonObject.class);
                Optional<String> b64d = StreamSupport.stream(f1jo.getAsJsonArray("properties").spliterator(), false).filter(n -> {
                    JsonObject jo = n.getAsJsonObject();
                    return !jo.get("name").isJsonNull() && jo.get("name").getAsString().equals("textures");
                }).map(n -> n.getAsJsonObject().get("value").getAsString()).findAny();
                if (!b64d.isPresent()) {
                    PLAYERSKINURLS.put(this.uuid, "");
                }
                byte[] b = Base64.getUrlDecoder().decode(b64d.get());
                String de1 = new String(b, StandardCharsets.UTF_8);
                JsonObject f2jo = (JsonObject)gson.fromJson(de1, JsonObject.class);
                PLAYERSKINURLS.put(this.uuid, f2jo.getAsJsonObject("textures").getAsJsonObject("SKIN").get("url").getAsString());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private static class NameLoader
    extends Thread {
        private String uuid;

        public NameLoader(String uuid) {
            this.uuid = uuid;
        }

        @Override
        public void run() {
            try {
                String f1 = IKSGURLUtil.getURLResponse("https://sessionserver.mojang.com/session/minecraft/profile/" + this.uuid);
                JsonObject f1jo = (JsonObject)gson.fromJson(f1, JsonObject.class);
                PLAYERNAMES.put(this.uuid, f1jo.get("name").getAsString());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private static class GameProfileLoader
    extends Thread {
        private String name;

        public GameProfileLoader(String name) {
            this.name = name;
        }

        @Override
        public void run() {
            GameProfile gp = PLAYERGAMEPROFILES.get(this.name);
            PLAYERGAMEPROFILES.put(this.name, SkullTileEntity.func_174884_b((GameProfile)gp));
        }
    }
}

