/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.otyacraftengine.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import red.felnull.otyacraftengine.client.config.ClientConfig;
import red.felnull.otyacraftengine.client.util.IKSGClientUtil;

public class IKSGTagUtil {
    public static Set<ResourceLocation> getItemTags(Item item) {
        return item.getTags();
    }

    public static Set<ResourceLocation> getItemTags(Block block) {
        return IKSGTagUtil.getItemTags(Item.func_150898_a((Block)block));
    }

    public static Set<ResourceLocation> getBlockTags(Block block) {
        return block.getTags();
    }

    public static Set<ResourceLocation> getBlockTags(Item item) {
        if (!(item instanceof BlockItem)) {
            return new HashSet<ResourceLocation>();
        }
        return IKSGTagUtil.getBlockTags(Block.func_149634_a((Item)item));
    }

    public static Set<ResourceLocation> getEntityTags(EntityType<?> type) {
        return type.getTags();
    }

    public static Set<ResourceLocation> getEntityTagsByItem(ItemStack stack) {
        if (stack.func_77973_b() instanceof SpawnEggItem) {
            return IKSGTagUtil.getEntityTags(((SpawnEggItem)stack.func_77973_b()).func_208076_b(stack.func_77978_p()));
        }
        return new HashSet<ResourceLocation>();
    }

    public static Set<ResourceLocation> getEnchantmentTags(Enchantment enchantment) {
        return enchantment.getTags();
    }

    public static Set<ResourceLocation> getPotionTags(Potion potion) {
        return potion.getTags();
    }

    public static Set<ResourceLocation> getTileEntityTags(TileEntityType<?> tile) {
        return tile.getTags();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addTagTooltip(ItemStack itemIn, List<ITextComponent> lores) {
        Set<ResourceLocation> itemTags = IKSGTagUtil.getItemTags(itemIn.func_77973_b());
        Set<ResourceLocation> blockTags = IKSGTagUtil.getBlockTags(itemIn.func_77973_b());
        Set<ResourceLocation> entityTags = IKSGTagUtil.getEntityTagsByItem(itemIn);
        Set<ResourceLocation> potionTags = IKSGTagUtil.getPotionTags(PotionUtils.func_185191_c((ItemStack)itemIn));
        if (itemTags.isEmpty() && blockTags.isEmpty() && entityTags.isEmpty() && potionTags.isEmpty()) {
            return;
        }
        if (!IKSGClientUtil.isKeyInput((String)ClientConfig.ToolTipTagKey.get(), true)) {
            lores.add((ITextComponent)new TranslationTextComponent("tooltip.tag.press", new Object[]{IKSGClientUtil.getKeyBind((String)ClientConfig.ToolTipTagKey.get()).func_238171_j_()}).func_240699_a_(TextFormatting.WHITE));
            return;
        }
        if (!itemTags.isEmpty()) {
            lores.add((ITextComponent)new TranslationTextComponent("tooltip.tag.item").func_240699_a_(TextFormatting.AQUA));
            itemTags.forEach(tags -> lores.add((ITextComponent)new StringTextComponent("- " + tags.toString()).func_240699_a_(TextFormatting.GRAY)));
        }
        if (!blockTags.isEmpty()) {
            lores.add((ITextComponent)new TranslationTextComponent("tooltip.tag.block").func_240699_a_(TextFormatting.AQUA));
            blockTags.forEach(tags -> lores.add((ITextComponent)new StringTextComponent("- " + tags.toString()).func_240699_a_(TextFormatting.GRAY)));
        }
        if (!entityTags.isEmpty()) {
            lores.add((ITextComponent)new TranslationTextComponent("tooltip.tag.entitytype").func_240699_a_(TextFormatting.AQUA));
            entityTags.forEach(tags -> lores.add((ITextComponent)new StringTextComponent("- " + tags.toString()).func_240699_a_(TextFormatting.GRAY)));
        }
        if (!potionTags.isEmpty()) {
            lores.add((ITextComponent)new TranslationTextComponent("tooltip.tag.potion").func_240699_a_(TextFormatting.AQUA));
            potionTags.forEach(tags -> lores.add((ITextComponent)new StringTextComponent("- " + tags.toString()).func_240699_a_(TextFormatting.GRAY)));
        }
    }
}

