/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.otyacraftengine.util;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import org.apache.commons.lang3.ArrayUtils;

public class IKSGVoxelShapeUtil {
    public static VoxelShape makeCuboidShaoe0(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Block.func_208617_a((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }

    public static VoxelShape makeCuboidShaoe90(double x1, double y1, double z1, double x2, double y2, double z2) {
        return IKSGVoxelShapeUtil.makeCuboidShaoe0(z1, y1, 16.0 - x1, z2, y2, 16.0 - x2);
    }

    public static VoxelShape makeCuboidShaoe180(double x1, double y1, double z1, double x2, double y2, double z2) {
        return IKSGVoxelShapeUtil.makeCuboidShaoe0(16.0 - x1, y1, 16.0 - z1, 16.0 - x2, y2, 16.0 - z2);
    }

    public static VoxelShape makeCuboidShaoe270(double x1, double y1, double z1, double x2, double y2, double z2) {
        return IKSGVoxelShapeUtil.makeCuboidShaoe180(z1, y1, 16.0 - x1, z2, y2, 16.0 - x2);
    }

    public static VoxelShape addCuboidShaoe0(double x1, double y1, double z1, double x2, double y2, double z2) {
        return IKSGVoxelShapeUtil.makeCuboidShaoe0(x1, y1, z1, x1 + x2, y1 + y2, z1 + z2);
    }

    public static VoxelShape addCuboidShaoe90(double x1, double y1, double z1, double x2, double y2, double z2) {
        return IKSGVoxelShapeUtil.makeCuboidShaoe90(x1, y1, z1, x1 + x2, y1 + y2, z1 + z2);
    }

    public static VoxelShape addCuboidShaoe180(double x1, double y1, double z1, double x2, double y2, double z2) {
        return IKSGVoxelShapeUtil.makeCuboidShaoe180(x1, y1, z1, x1 + x2, y1 + y2, z1 + z2);
    }

    public static VoxelShape addCuboidShaoe270(double x1, double y1, double z1, double x2, double y2, double z2) {
        return IKSGVoxelShapeUtil.makeCuboidShaoe270(x1, y1, z1, x1 + x2, y1 + y2, z1 + z2);
    }

    public static VoxelShape allOr(VoxelShape ... shapes) {
        return VoxelShapes.func_216384_a((VoxelShape)shapes[0], (VoxelShape[])((VoxelShape[])ArrayUtils.remove((Object[])shapes, (int)0)));
    }

    public static VoxelShape translate(VoxelShape shape, double x, double y, double z) {
        Object[] shapes = new VoxelShape[]{};
        for (AxisAlignedBB aabb : shape.func_197756_d()) {
            shapes = (VoxelShape[])ArrayUtils.add((Object[])shapes, (Object)VoxelShapes.func_197881_a((AxisAlignedBB)aabb.func_72317_d(0.0625 * x, 0.0625 * y, 0.0625 * z)));
        }
        return IKSGVoxelShapeUtil.allOr((VoxelShape[])shapes);
    }

    public static VoxelShape rotate90(VoxelShape shape) {
        ArrayList shapes = new ArrayList();
        shape.func_197756_d().forEach(n -> shapes.add(VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(n.field_72339_c, n.field_72338_b, 1.0 - n.field_72340_a, n.field_72334_f, n.field_72337_e, 1.0 - n.field_72336_d))));
        return IKSGVoxelShapeUtil.allOr(shapes.toArray(new VoxelShape[1]));
    }

    public static VoxelShape rotate180(VoxelShape shape) {
        ArrayList shapes = new ArrayList();
        shape.func_197756_d().forEach(n -> shapes.add(VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(1.0 - n.field_72340_a, n.field_72338_b, 1.0 - n.field_72339_c, 1.0 - n.field_72336_d, n.field_72337_e, 1.0 - n.field_72334_f))));
        return IKSGVoxelShapeUtil.allOr(shapes.toArray(new VoxelShape[1]));
    }

    public static VoxelShape rotate270(VoxelShape shape) {
        shape = IKSGVoxelShapeUtil.rotate180(shape);
        ArrayList shapes = new ArrayList();
        shape.func_197756_d().forEach(n -> shapes.add(VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(n.field_72339_c, n.field_72338_b, 1.0 - n.field_72340_a, n.field_72334_f, n.field_72337_e, 1.0 - n.field_72336_d))));
        return IKSGVoxelShapeUtil.allOr(shapes.toArray(new VoxelShape[1]));
    }

    public static VoxelShape rotateDirection(VoxelShape shape, Direction direction) {
        switch (direction) {
            case SOUTH: {
                return IKSGVoxelShapeUtil.rotate180(shape);
            }
            case EAST: {
                return IKSGVoxelShapeUtil.rotate270(shape);
            }
            case WEST: {
                return IKSGVoxelShapeUtil.rotate90(shape);
            }
        }
        return shape;
    }
}

